/*
 * Decompiled with CFR 0.152.
 */
package org.directtruststandards.timplus.common.cert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.directtruststandards.timplus.common.cert.CertificateConversionException;
import org.directtruststandards.timplus.common.cert.WrappedOnDemandX509CertificateEx;
import org.directtruststandards.timplus.common.cert.X509CertificateEx;
import org.directtruststandards.timplus.common.crypto.KeyStoreProtectionManager;
import org.directtruststandards.timplus.common.crypto.MutableKeyStoreProtectionManager;
import org.directtruststandards.timplus.common.crypto.exceptions.CryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertStoreUtils {
    private static final byte[] KEY_PAIR_START_STRING = CertStoreUtils.getSafeChars();
    private static final Logger LOGGER = LoggerFactory.getLogger(CertStoreUtils.class);

    private static byte[] getSafeChars() {
        byte[] retVal = null;
        try {
            retVal = "STARTCERTPRIVKEYPAIR".getBytes("ASCII");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static X509Certificate certFromData(KeyStoreProtectionManager mgr, byte[] data) throws CryptoException {
        X509Certificate retVal;
        block11: {
            retVal = null;
            try {
                CertContainer container = CertStoreUtils.toCertContainer(data);
                if (container.getWrappedKeyData() != null) {
                    if (mgr == null) {
                        throw new CryptoException("Resolved certifiate has wrapped data, but resolver has not been configured to unwrap it.");
                    }
                    retVal = WrappedOnDemandX509CertificateEx.fromX509Certificate(mgr, container.getCert(), container.getWrappedKeyData());
                    return retVal;
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                try {
                    KeyStore localKeyStore = KeyStore.getInstance("PKCS12", "BC");
                    localKeyStore.load(bais, "".toCharArray());
                    Enumeration<String> aliases = localKeyStore.aliases();
                    if (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                        Key key = localKeyStore.getKey(alias, "".toCharArray());
                        retVal = key != null && key instanceof PrivateKey ? X509CertificateEx.fromX509Certificate(cert, (PrivateKey)key) : cert;
                    }
                }
                catch (Exception localKeyStore) {
                    // empty catch block
                }
                if (retVal == null) {
                    bais.reset();
                    bais = new ByteArrayInputStream(data);
                    retVal = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
                }
                bais.close();
                if (mgr == null || retVal instanceof X509CertificateEx || !(mgr instanceof MutableKeyStoreProtectionManager)) break block11;
                try {
                    PrivateKey pKey;
                    KeyStore ks = ((MutableKeyStoreProtectionManager)mgr).getKS();
                    String alias = ks.getCertificateAlias(retVal);
                    if (!StringUtils.isEmpty((CharSequence)alias) && (pKey = (PrivateKey)ks.getKey(alias, "".toCharArray())) != null) {
                        retVal = X509CertificateEx.fromX509Certificate(retVal, pKey);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Could not retrieve the private key from the PKCS11 token: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                throw new CryptoException("Data cannot be converted to a valid X.509 Certificate", e);
            }
        }
        return retVal;
    }

    protected static boolean isByteDataWrappedKeyPair(byte[] data) {
        if (data.length <= KEY_PAIR_START_STRING.length) {
            return false;
        }
        for (int idx = 0; idx < KEY_PAIR_START_STRING.length; ++idx) {
            if (data[idx] == KEY_PAIR_START_STRING[idx]) continue;
            return false;
        }
        return true;
    }

    public static CertContainer toCertContainer(byte[] data) throws CertificateConversionException {
        return CertStoreUtils.toCertContainer(data, "".toCharArray(), "".toCharArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CertContainer toCertContainer(byte[] data, char[] keyStorePassPhrase, char[] privateKeyPassPhrase) throws CertificateConversionException {
        CertContainer certContainer = null;
        try {
            ByteArrayInputStream bais;
            block19: {
                if (CertStoreUtils.isByteDataWrappedKeyPair(data)) {
                    int idx = KEY_PAIR_START_STRING.length;
                    int high = data[idx] >= 0 ? data[idx] : data[idx] + 256;
                    int low = data[++idx] >= 0 ? data[idx] : data[idx] + 256;
                    int wrappedDatasize = low | high << 8;
                    byte[] wrappedData = Arrays.copyOfRange(data, ++idx, idx + wrappedDatasize);
                    try (ByteArrayInputStream bais2 = new ByteArrayInputStream(Arrays.copyOfRange(data, idx += wrappedDatasize, data.length));){
                        CertContainer certContainer2 = new CertContainer((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais2), wrappedData);
                        return certContainer2;
                    }
                }
                bais = new ByteArrayInputStream(data);
                try {
                    KeyStore localKeyStore = KeyStore.getInstance("PKCS12", "BC");
                    localKeyStore.load(bais, keyStorePassPhrase);
                    Enumeration<String> aliases = localKeyStore.aliases();
                    if (!aliases.hasMoreElements()) break block19;
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, privateKeyPassPhrase);
                    if (key != null && key instanceof PrivateKey) {
                        certContainer = new CertContainer(cert, key);
                    }
                }
                catch (Exception localKeyStore) {
                    // empty catch block
                }
            }
            if (certContainer == null) {
                bais.reset();
                bais = new ByteArrayInputStream(data);
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
                certContainer = new CertContainer(cert, (Key)null);
            }
            bais.close();
            return certContainer;
        }
        catch (Exception e) {
            throw new CertificateConversionException("Data cannot be converted to a valid X.509 Certificate", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] certAndWrappedKeyToRawByteFormat(byte[] wrappedKey, X509Certificate cert) throws CertificateConversionException {
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            outStream.write(KEY_PAIR_START_STRING);
            int size = wrappedKey.length;
            outStream.write((byte)(size >> 8 & 0xFF));
            outStream.write((byte)(size & 0xFF));
            outStream.write(wrappedKey);
            outStream.write(cert.getEncoded());
            byte[] byArray = outStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new CertificateConversionException("Failed to convert wrapped key and cert to byte stream.", e);
        }
    }

    public static class CertContainer {
        private final X509Certificate cert;
        private final Key key;
        private final byte[] wrappedKeyData;

        public CertContainer(X509Certificate cert, Key key) {
            this.cert = cert;
            this.key = key;
            this.wrappedKeyData = null;
        }

        public CertContainer(X509Certificate cert, byte[] wrappedKeyData) {
            this.cert = cert;
            this.key = null;
            this.wrappedKeyData = wrappedKeyData;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public Key getKey() {
            return this.key;
        }

        public byte[] getWrappedKeyData() {
            return this.wrappedKeyData;
        }
    }
}

