/*
 * Decompiled with CFR 0.152.
 */
package org.directtruststandards.timplus.common.crypto.impl;

import java.security.KeyStore;
import java.util.HashMap;
import javax.crypto.spec.SecretKeySpec;
import org.directtruststandards.timplus.common.crypto.CryptoUtils;
import org.directtruststandards.timplus.common.crypto.impl.BootstrappedKeyStoreProtectionManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BootstrappedKeyStoreProtectionManager_constructTest {
    @Test
    public void testConstructBootstrappedKeyStoreProtectionManager_defaultContstructor() throws Exception {
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager();
        Assertions.assertNotNull((Object)mgr.keyEntries);
        Assertions.assertTrue((boolean)mgr.keyEntries.isEmpty());
        Assertions.assertNull((Object)mgr.keyStoreProtectionKey);
        Assertions.assertNull((Object)mgr.privateKeyProtectionKey);
    }

    @Test
    public void testConstructBootstrappedKeyStoreProtectionManager_keysAsString() throws Exception {
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager("Hello", "There");
        Assertions.assertNotNull((Object)mgr.keyEntries);
        Assertions.assertFalse((boolean)mgr.keyEntries.isEmpty());
        Assertions.assertEquals((int)2, (int)mgr.keyEntries.size());
        Assertions.assertNotNull((Object)mgr.keyStoreProtectionKey);
        Assertions.assertNotNull((Object)mgr.privateKeyProtectionKey);
    }

    @Test
    public void testConstructBootstrappedKeyStoreProtectionManager_keysAsStringAndEntries() throws Exception {
        HashMap<String, KeyStore.SecretKeyEntry> keyEntries = new HashMap<String, KeyStore.SecretKeyEntry>();
        SecretKeySpec key = new SecretKeySpec("Something".getBytes(), "");
        keyEntries.put("ThisEntry", new KeyStore.SecretKeyEntry(key));
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager("Hello", "There", keyEntries);
        Assertions.assertNotNull((Object)mgr.keyEntries);
        Assertions.assertEquals((int)3, (int)mgr.keyEntries.size());
        Assertions.assertNotNull((Object)mgr.keyStoreProtectionKey);
        Assertions.assertNotNull((Object)mgr.privateKeyProtectionKey);
    }

    static {
        CryptoUtils.registerJCEProviders();
    }
}

