/*
 * Decompiled with CFR 0.152.
 */
package org.directtruststandards.timplus.common.crypto.impl;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.SecretKey;
import org.directtruststandards.timplus.common.crypto.CryptoUtils;
import org.directtruststandards.timplus.common.crypto.impl.BootstrappedKeyStoreProtectionManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BootstrappedKeyStoreProtectionManagerTest {
    @Test
    public void testGetSetKeysFromString() throws Exception {
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager();
        mgr.setKeyStoreProtectionKey("1234");
        mgr.setPrivateKeyProtectionKey("5678");
        Assertions.assertNotNull((Object)mgr.getKeyStoreProtectionKey());
        Assertions.assertNotNull((Object)mgr.getPrivateKeyProtectionKey().getEncoded());
    }

    @Test
    public void testGetAllKeys() throws Exception {
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager();
        mgr.setKeyStoreProtectionKey("1234");
        mgr.setPrivateKeyProtectionKey("5678");
        Map keys = mgr.getAllKeys();
        Assertions.assertEquals((int)2, (int)keys.size());
        Iterator entryIter = keys.entrySet().iterator();
        Key key = (Key)entryIter.next().getValue();
        Assertions.assertNotNull((Object)key);
        key = (Key)entryIter.next().getValue();
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testWrapUnwrapKey() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        KeyPair pair = keyPairGenerator.generateKeyPair();
        pair.getPrivate();
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager();
        mgr.setKeyStoreProtectionKey("1234");
        mgr.setPrivateKeyProtectionKey("5678");
        byte[] wrappedKey = mgr.wrapWithSecretKey((SecretKey)mgr.getPrivateKeyProtectionKey(), (Key)pair.getPrivate());
        Assertions.assertNotNull((Object)wrappedKey);
        Key unwrappedKey = mgr.unwrapWithSecretKey((SecretKey)mgr.getPrivateKeyProtectionKey(), wrappedKey, "RSA", 2);
        Assertions.assertEquals((Object)unwrappedKey, (Object)pair.getPrivate());
    }

    static {
        CryptoUtils.registerJCEProviders();
    }
}

