/*
 * Decompiled with CFR 0.152.
 */
package org.directtruststandards.timplus.common.crypto.impl;

import java.io.InputStream;
import java.security.KeyStore;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.lang3.StringUtils;
import org.directtruststandards.timplus.common.crypto.exceptions.CryptoException;
import org.directtruststandards.timplus.common.crypto.impl.AbstractPKCS11TokenKeyStoreProtectionManager;

public class DynamicPKCS11TokenKeyStoreProtectionManager
extends AbstractPKCS11TokenKeyStoreProtectionManager {
    protected CallbackHandler handler;
    protected KeyStore.Builder keyStoreBuilder;

    public DynamicPKCS11TokenKeyStoreProtectionManager() throws CryptoException {
    }

    public DynamicPKCS11TokenKeyStoreProtectionManager(String keyStorePassPhraseAlias, String privateKeyPassPhraseAlias, CallbackHandler handler) throws CryptoException {
        this(keyStorePassPhraseAlias, keyStorePassPhraseAlias, handler, null, null);
    }

    public DynamicPKCS11TokenKeyStoreProtectionManager(String keyStorePassPhraseAlias, String privateKeyPassPhraseAlias, CallbackHandler handler, String keyStoreType, InputStream inputStream) throws CryptoException {
        this.keyStorePassPhraseAlias = keyStorePassPhraseAlias;
        this.privateKeyPassPhraseAlias = privateKeyPassPhraseAlias;
        this.handler = handler;
        this.keyStoreType = StringUtils.isEmpty((CharSequence)keyStoreType) ? keyStoreType : "PKCS11";
        this.configureKeyStoreBuilder();
        this.initTokenStore();
    }

    public void setCallbackHandler(CallbackHandler handler) {
        this.handler = handler;
        this.configureKeyStoreBuilder();
    }

    protected void configureKeyStoreBuilder() {
        KeyStore.CallbackHandlerProtection chp = new KeyStore.CallbackHandlerProtection(this.handler);
        this.keyStoreBuilder = KeyStore.Builder.newInstance(this.keyStoreType, null, chp);
    }

    @Override
    public void initTokenStore() throws CryptoException {
        try {
            this.loadProvider();
            this.ks = this.keyStoreBuilder.getKeyStore();
            this.ks.load(this.keyStoreSource, null);
        }
        catch (Exception e) {
            throw new CryptoException("Error initializing PKCS11 token", e);
        }
    }
}

