/*
 * Decompiled with CFR 0.152.
 */
package org.directtruststandards.timplus.common.crypto;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.security.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtils {
    private static final String DEFAULT_JCE_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final String DEFAULT_SENSITIVE_JCE_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final Logger LOGGER = LoggerFactory.getLogger(CryptoUtils.class);

    public static void registerJCEProviders() {
        String[] providerClasses;
        for (String providerClass : providerClasses = new String[]{"org.bouncycastle.jce.provider.BouncyCastleProvider"}) {
            try {
                Class<?> providerClazz = CryptoUtils.class.getClassLoader().loadClass(providerClass);
                Provider provider = (Provider)Provider.class.cast(providerClazz.newInstance());
                if (Security.getProvider(provider.getName()) != null) continue;
                Security.addProvider(provider);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not load and/or register JCE provider " + providerClass, e);
            }
        }
        for (String providerClass : providerClasses = new String[]{"org.bouncycastle.jce.provider.BouncyCastleProvider"}) {
            try {
                Class<?> providerClazz;
                Provider provider;
                block12: {
                    provider = null;
                    providerClazz = null;
                    String[] provParams = providerClass.split(";");
                    if (provParams.length > 1) {
                        providerClazz = CryptoUtils.class.getClassLoader().loadClass(provParams[0]);
                        try {
                            Constructor constr = (Constructor)Constructor.class.cast(providerClazz.getConstructor(String.class));
                            provider = (Provider)constr.newInstance(provParams[1]);
                        }
                        catch (InvocationTargetException e) {
                            if (e.getTargetException() instanceof IllegalStateException) {
                                LOGGER.warn("Could not create a JCE Provider with the specific parameter: " + provParams[1], (Throwable)e);
                                break block12;
                            }
                            LOGGER.warn("JCE Provider param  " + provParams[1] + " provided but not supported by JCE Provider implementation:" + e.getMessage(), (Throwable)e);
                        }
                    } else {
                        providerClazz = CryptoUtils.class.getClassLoader().loadClass(providerClass);
                    }
                }
                if (provider == null) {
                    provider = (Provider)Provider.class.cast(providerClazz.newInstance());
                }
                if (Security.getProvider(provider.getName()) != null) continue;
                Security.addProvider(provider);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not load and/or register sensitive JCE provider " + providerClass, e);
            }
        }
    }

    public static void registerJCEProvider(Provider provider) {
        if (Security.getProvider(provider.getName()) == null) {
            Security.addProvider(provider);
        }
    }
}

