/*
 * Decompiled with CFR 0.152.
 */
package org.directtruststandards.timplus.common.cert;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class Thumbprint {
    private final byte[] digest;
    private final String digestString;

    public static Thumbprint toThumbprint(X509Certificate cert) {
        Thumbprint retVal = null;
        if (cert == null) {
            throw new IllegalArgumentException();
        }
        try {
            retVal = new Thumbprint(cert);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return retVal;
    }

    public static Thumbprint toThumbprint(byte[] bytes) throws NoSuchAlgorithmException {
        Thumbprint retVal = null;
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        try {
            retVal = new Thumbprint(bytes);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return retVal;
    }

    private Thumbprint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        this(cert.getEncoded());
    }

    private Thumbprint(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = bytes;
        md.update(der);
        this.digest = md.digest();
        this.digestString = this.createStringRep();
    }

    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    private String createStringRep() {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(this.digest.length * 2);
        for (byte bt : this.digest) {
            buf.append(hexDigits[(bt & 0xF0) >> 4]);
            buf.append(hexDigits[bt & 0xF]);
        }
        return buf.toString();
    }

    public String toString() {
        return this.digestString;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Thumbprint)) {
            return false;
        }
        Thumbprint compareTo = (Thumbprint)obj;
        return Arrays.equals(compareTo.digest, this.digest);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

