/*
 * Decompiled with CFR 0.152.
 */
package org.directtruststandards.timplus.common.crypto.impl;

import java.security.KeyStore;
import java.util.HashMap;
import javax.crypto.spec.SecretKeySpec;
import org.directtruststandards.timplus.common.crypto.CryptoUtils;
import org.directtruststandards.timplus.common.crypto.impl.BootstrappedKeyStoreProtectionManager;
import org.junit.Assert;
import org.junit.Test;

public class BootstrappedKeyStoreProtectionManager_constructTest {
    @Test
    public void testConstructBootstrappedKeyStoreProtectionManager_defaultContstructor() throws Exception {
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager();
        Assert.assertNotNull((Object)mgr.keyEntries);
        Assert.assertTrue((boolean)mgr.keyEntries.isEmpty());
        Assert.assertNull((Object)mgr.keyStoreProtectionKey);
        Assert.assertNull((Object)mgr.privateKeyProtectionKey);
    }

    @Test
    public void testConstructBootstrappedKeyStoreProtectionManager_keysAsString() throws Exception {
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager("Hello", "There");
        Assert.assertNotNull((Object)mgr.keyEntries);
        Assert.assertFalse((boolean)mgr.keyEntries.isEmpty());
        Assert.assertEquals((long)2L, (long)mgr.keyEntries.size());
        Assert.assertNotNull((Object)mgr.keyStoreProtectionKey);
        Assert.assertNotNull((Object)mgr.privateKeyProtectionKey);
    }

    @Test
    public void testConstructBootstrappedKeyStoreProtectionManager_keysAsStringAndEntries() throws Exception {
        HashMap<String, KeyStore.SecretKeyEntry> keyEntries = new HashMap<String, KeyStore.SecretKeyEntry>();
        SecretKeySpec key = new SecretKeySpec("Something".getBytes(), "");
        keyEntries.put("ThisEntry", new KeyStore.SecretKeyEntry(key));
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager("Hello", "There", keyEntries);
        Assert.assertNotNull((Object)mgr.keyEntries);
        Assert.assertEquals((long)3L, (long)mgr.keyEntries.size());
        Assert.assertNotNull((Object)mgr.keyStoreProtectionKey);
        Assert.assertNotNull((Object)mgr.privateKeyProtectionKey);
    }

    static {
        CryptoUtils.registerJCEProviders();
    }
}

