/*
 * Decompiled with CFR 0.152.
 */
package jpower.json.serialization;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import jpower.core.out.IndentPrinter;
import jpower.json.ObjectMapper;
import jpower.json.serialization.JSONStyle;

public class JSONSerializer {
    private final JSONStyle style;
    private final ObjectMapper mapper = new ObjectMapper();

    public JSONSerializer(JSONStyle style) {
        this.style = style;
    }

    public String serialize(Object object) throws IOException {
        if (Map.class.isAssignableFrom(object.getClass())) {
            return this.serialize((Map)object);
        }
        if (Collection.class.isAssignableFrom(object.getClass())) {
            return this.serialize((Collection)object);
        }
        return this.serialize(this.mapper.create(object));
    }

    public String serialize(Collection<?> list) throws IOException {
        StringWriter writer = new StringWriter();
        IndentPrinter out = new IndentPrinter(this.style.getIndention(), writer);
        out.write('[');
        int count = 0;
        for (Object entry : list) {
            this.toJSON(entry, out);
            if (++count == list.size()) continue;
            out.write(',');
        }
        out.write(']');
        out.close();
        return writer.toString();
    }

    public String serialize(Map<?, ?> map) throws IOException {
        StringWriter writer = new StringWriter();
        IndentPrinter out = new IndentPrinter(this.style.getIndention(), writer);
        out.write('{');
        int count = 0;
        for (Object key : map.keySet()) {
            ++count;
            Object value = map.get(key);
            out.write(this.style.isSingleQuotes() ? (char)'\'' : '\"');
            out.print(key.toString());
            out.write(this.style.isSingleQuotes() ? (char)'\'' : '\"');
            out.write(':');
            this.toJSON(value, out);
            if (count == map.keySet().size()) continue;
            out.write(',');
        }
        out.write('}');
        out.close();
        return writer.toString();
    }

    public void toJSON(Object value, IndentPrinter out) throws IOException {
        if (value == null) {
            out.print("null");
        } else if (Number.class.isAssignableFrom(value.getClass())) {
            out.print(JSONSerializer.toJSON((Number)value));
        } else if (String.class.isAssignableFrom(value.getClass())) {
            out.print(JSONSerializer.toJSON((String)value, this.style));
        } else {
            out.print(this.serialize(value));
        }
    }

    public static String toJSON(Number number) {
        return number.toString();
    }

    public static String toJSON(String str, JSONStyle style) {
        return (style.isSingleQuotes() ? (char)'\'' : '\"') + str + (style.isSingleQuotes() ? (char)'\'' : '\"');
    }
}

