/*
 * Decompiled with CFR 0.152.
 */
package jpower.irc;

import jpower.irc.PowerIrc;
import jpower.irc.Sendable;

public class User
implements Sendable {
    private final PowerIrc client;
    private final String username;
    private final String realname;
    private final String hostname;
    private String nickname;

    public User(PowerIrc client, String nickname) {
        this(client, "", nickname);
    }

    public User(PowerIrc client, String username, String nickname) {
        this(client, username, nickname, "");
    }

    public User(PowerIrc client, String username, String nickname, String hostname) {
        this(client, username, nickname, hostname, "");
    }

    public User(PowerIrc client, String username, String nickname, String hostname, String realname) {
        this.client = client;
        this.username = username;
        this.nickname = nickname;
        this.hostname = hostname;
        this.realname = realname;
    }

    @Override
    public String getName() {
        return this.nickname;
    }

    public void queueWhois() {
        this.client.whois(this.nickname);
    }

    public String getUsername() {
        return this.username;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getHost() {
        return this.hostname;
    }

    @Override
    public void message(String message) {
        this.client.privmsg(this, message);
    }
}

