/*
 * Decompiled with CFR 0.152.
 */
package jpower.gui.internal;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JPanel;
import jpower.core.Worker;
import jpower.core.utils.NetUtils;
import jpower.gui.GuiApp;

public class DebuggerApp
extends GuiApp {
    private final JPanel panel = new JPanel();
    private final Worker worker = new Worker();

    @Override
    public void build() {
        this.getFrame().setTitle("JPower Debugger");
        this.getFrame().setExtendedState(this.getFrame().getExtendedState() | 6);
        this.panel.setLayout(new GridLayout(12, 4));
        this.createButton("Download Test File", event -> {
            try {
                NetUtils.download("https://raw.github.com/git/git/master/Documentation/RelNotes/1.9.0.txt", new File("git-release-notes.txt"));
            }
            catch (IOException e) {
                this.showDialog("Error", "ERROR: " + e.getMessage(), 0);
            }
        });
        this.createButton("Delete Test File", event -> {
            boolean deleted = new File("git-release-notes.txt").delete();
            if (!deleted) {
                this.showDialog("Error", "Failed to delete file!", 0);
            }
        });
        this.createButton("Start Worker", event -> this.worker.start());
        this.createButton("Stop Worker", event -> this.worker.stop());
        this.createButton("Test Worker", event -> this.worker.addTask(() -> this.showDialog("Hello", "Hello World!", 1)));
        this.getFrame().add(this.panel);
    }

    public JButton createButton(String name, Consumer<ActionEvent> consumer) {
        JButton button = new JButton(name);
        button.addActionListener(consumer::accept);
        button.setSize(200, 100);
        this.panel.add(button);
        return button;
    }

    public static void main(String[] args) {
        new DebuggerApp().show();
    }
}

