/*
 * Decompiled with CFR 0.152.
 */
package jpower.gui;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jpower.event.EventBus;

public abstract class GuiApp {
    private final JFrame frame = new JFrame();
    private final EventBus eventBus = new EventBus();
    private boolean built;

    public GuiApp() {
        this.setDefaults();
    }

    private void setDefaults() {
        this.frame.setLocationRelativeTo(null);
        this.frame.setSize(500, 200);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setTitle("GUI");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
    }

    public abstract void build();

    public JFrame getFrame() {
        return this.frame;
    }

    public void show() {
        if (!this.built) {
            this.built = true;
            this.build();
        }
        this.frame.setVisible(true);
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void showDialog(String title, String message, int type) {
        JOptionPane.showMessageDialog(this.frame, message, title, type);
    }
}

