/*
 * Decompiled with CFR 0.152.
 */
package jpower.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import jpower.core.Wrapper;
import jpower.event.RegisteredMethod;

public class RegisteredHandler {
    private final Object object;
    private final Collection<RegisteredMethod> methods = new ArrayList<RegisteredMethod>();
    private Class<? extends Annotation> annotationType;

    public RegisteredHandler(Object object) {
        this.object = object;
    }

    public RegisteredHandler setAnnotationType(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
        return this;
    }

    public RegisteredHandler registerMethods() {
        for (Method method : this.object.getClass().getMethods()) {
            if (!this.isEventMethod(method)) continue;
            this.methods.add(new RegisteredMethod(method));
        }
        return this;
    }

    public boolean isEventMethod(Method method) {
        return method.isAnnotationPresent(this.annotationType) && method.getParameterTypes().length == 1;
    }

    public boolean executeEvent(Object event) {
        Wrapper<Boolean> executed = new Wrapper<Boolean>(false);
        this.methods.forEach(method -> {
            if (method.getEventType().isAssignableFrom(event.getClass())) {
                method.invoke(this.object, event);
                executed.set(true);
            }
        });
        return executed.get();
    }

    public Object getObject() {
        return this.object;
    }
}

