/*
 * Decompiled with CFR 0.152.
 */
package jpower.core.utils;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import jpower.core.utils.FileUtils;
import jpower.core.utils.IOUtils;

public class NetUtils {
    public static boolean ping(String host) {
        try {
            return InetAddress.getByName(host).isReachable(1000);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static HttpURLConnection getConnection(String url) throws IOException {
        return (HttpURLConnection)new URL(url).openConnection();
    }

    public static void download(String url, File location) throws IOException {
        FileUtils.write(location, IOUtils.getBytes(NetUtils.getConnection(url).getInputStream()));
    }

    public static String localIPAddress() {
        return InetAddress.getLoopbackAddress().getHostAddress();
    }
}

