/*
 * Decompiled with CFR 0.152.
 */
package jpower.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ListUtils {
    public static <T> List<T> singleton(T single) {
        return Collections.singletonList(single);
    }

    public static String toString(List<String> lines) {
        return ListUtils.join(lines, System.lineSeparator());
    }

    public static String join(List<String> inputs, String joinBy) {
        StringBuilder builder = new StringBuilder();
        ListUtils.forEach(inputs, (input, i) -> {
            if (i != 0) {
                builder.append((String)input);
            }
            builder.append((String)input);
        });
        return builder.toString();
    }

    public static <T> boolean equals(@NotNull T[] array, @NotNull List<T> list) {
        Object[] listArray = list.toArray();
        return Arrays.equals(array, listArray);
    }

    public static <T> void forEach(List<T> that, BiConsumer<T, Integer> consumer) {
        for (int i = 0; i < that.size(); ++i) {
            consumer.accept(that.get(i), i);
        }
    }

    public static <T> Set<T> toSet(List<T> list) {
        return Collections.unmodifiableSet(new HashSet<T>(list));
    }

    public static <T, R> List<R> collect(List<T> input, Function<T, R> function) {
        ArrayList newStuff = new ArrayList();
        input.forEach(entry -> newStuff.add(function.apply(entry)));
        return newStuff;
    }
}

