/*
 * Decompiled with CFR 0.152.
 */
package jpower.core.out;

import java.io.IOException;
import java.io.Writer;

public class IndentPrinter
implements AutoCloseable {
    private final Writer writer;
    private final String indentation;
    private int level = 0;

    public IndentPrinter(String indentation, Writer writer) {
        this.indentation = indentation;
        this.writer = writer;
    }

    public void increment() {
        ++this.level;
    }

    public void decrement() {
        --this.level;
    }

    public void printIndent() throws IOException {
        for (int i = 0; i < this.level; ++i) {
            this.writer.write(this.indentation);
        }
    }

    public void println() throws IOException {
        this.println("");
    }

    public void println(String line) throws IOException {
        this.writer.write(line + '\n');
    }

    public void print(String str) throws IOException {
        this.writer.write(str);
    }

    public void write(char character) throws IOException {
        this.writer.write(new char[]{character});
    }

    public void write(char[] chars) throws IOException {
        this.writer.write(chars);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

