/*
 * Decompiled with CFR 0.152.
 */
package jpower.core;

public class Platform {
    private static final Platform current = new Platform(System.getProperty("os.name"));
    private final String name;

    private Platform(String name) {
        this.name = name.toLowerCase();
    }

    public static Platform getCurrent() {
        return current;
    }

    public static String getProcessorArchitecture() {
        return System.getProperty("os.arch");
    }

    public boolean isWindows() {
        return this.name.contains("win");
    }

    public boolean isMacintosh() {
        return this.name.contains("mac");
    }

    public boolean isUnix() {
        return this.name.contains("nix") || this.name.contains("nux") || this.name.contains("aix");
    }

    public boolean isSolaris() {
        return this.name.contains("sunos");
    }

    public boolean isUnknown() {
        return !this.isWindows() && !this.isMacintosh() && !this.isUnix() && !this.isSolaris();
    }
}

