/*
 * Decompiled with CFR 0.152.
 */
package jpower.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import jpower.core.Service;
import jpower.core.WorkerPool;
import jpower.core.utils.ThreadUtils;
import jpower.socket.Client;
import jpower.socket.ClientHandler;

public class WorkerServer
implements Service {
    private final ServerSocket server = new ServerSocket();
    private final InetSocketAddress address;
    private final WorkerPool workerPool = new WorkerPool(30);
    private ClientHandler clientHandler;
    private Thread acceptThread;
    private boolean shouldRun;

    public WorkerServer(String host, int port) throws IOException {
        this.address = new InetSocketAddress(host, port);
    }

    public void setClientHandler(ClientHandler clientHandler) {
        this.clientHandler = clientHandler;
    }

    @Override
    public boolean start() {
        this.shouldRun = true;
        try {
            this.server.bind(this.address);
        }
        catch (IOException e) {
            return false;
        }
        this.acceptThread = ThreadUtils.start(() -> {
            while (this.shouldRun) {
                this.workerPool.submit(() -> {
                    try {
                        this.clientHandler.handleClient(new Client(this.server.accept()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
        });
        return true;
    }

    @Override
    public boolean stop() {
        this.shouldRun = false;
        this.workerPool.waitForAll();
        return true;
    }
}

