/*
 * Decompiled with CFR 0.152.
 */
package jpower.core.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;

public class IOUtils {
    public static String getResourceAsString(Class clazz, String file) {
        InputStream stream = clazz.getResourceAsStream(file);
        if (stream == null) {
            return null;
        }
        return IOUtils.readStringFromStream(stream);
    }

    public static String readStringFromStream(InputStream stream) {
        BufferedReader reader = IOUtils.createBufferedReader(stream);
        StringWriter writer = new StringWriter();
        try {
            int b;
            while ((b = reader.read()) != -1) {
                writer.write(b);
            }
            stream.close();
        }
        catch (IOException e) {
            return null;
        }
        return writer.toString();
    }

    public static byte[] getBytes(InputStream stream) throws IOException {
        byte b;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while ((b = (byte)stream.read()) != -1) {
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    public static BufferedReader createBufferedReader(InputStream stream) {
        return IOUtils.createBufferedReader(IOUtils.createReader(stream));
    }

    public static BufferedReader createBufferedReader(Reader reader) {
        return new BufferedReader(reader);
    }

    public static Reader createReader(InputStream stream) {
        return new InputStreamReader(stream);
    }

    public static PrintStream createPrintStream(OutputStream stream) {
        return new PrintStream(stream);
    }
}

