/*
 * Decompiled with CFR 0.152.
 */
package jpower.core;

import java.util.ArrayList;
import java.util.List;
import jpower.core.ConditionalExecutor;
import jpower.core.Task;
import jpower.core.Worker;
import jpower.core.utils.ThreadUtils;

public class WorkerPool {
    private final List<Worker> workers = new ArrayList<Worker>();
    private final int size;

    public WorkerPool() {
        this(50);
    }

    public WorkerPool(int size) {
        this.size = size;
    }

    public boolean submit(Task task) {
        Worker worker = this.pullWorker();
        if (worker != null) {
            worker.addTask(task);
            return true;
        }
        return false;
    }

    private Worker pullWorker() {
        if (this.workers.isEmpty()) {
            Worker worker = new Worker();
            this.workers.add(worker);
            return worker;
        }
        for (Worker w : this.workers) {
            if (w.isWorking()) continue;
            return w;
        }
        return this.newWorker();
    }

    private Worker newWorker() {
        if (this.workers.size() == this.size) {
            return null;
        }
        Worker worker = new Worker();
        worker.start();
        this.workers.add(worker);
        return worker;
    }

    public List<Worker> getWorkers() {
        return this.workers;
    }

    public void stopWorkers() {
        ArrayList<Worker> temp = new ArrayList<Worker>(this.workers);
        temp.forEach(worker -> {
            worker.stop();
            new ConditionalExecutor(() -> ThreadUtils.sleep(1L)).until(worker::isWorking);
            this.workers.remove(worker);
        });
    }

    public int getWorkerCount() {
        return this.workers.size();
    }

    public void waitForAll() {
        this.workers.forEach(Worker::waitFor);
    }
}

