/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.providers.impl;

import com.sdl.web.api.content.PageContentRetriever;
import com.sdl.web.api.content.PageContentRetrieverImpl;
import com.sdl.web.api.meta.WebPageMetaFactory;
import com.sdl.web.api.meta.WebPageMetaFactoryImpl;
import com.tridion.data.CharacterData;
import com.tridion.meta.PageMeta;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dd4t.caching.CacheElement;
import org.dd4t.caching.CacheType;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.NotImplementedException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.core.util.Constants;
import org.dd4t.core.util.TCMURI;
import org.dd4t.providers.BaseBrokerProvider;
import org.dd4t.providers.PageProvider;
import org.dd4t.providers.PageProviderResultItem;
import org.dd4t.providers.PageResultItemImpl;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerPageProvider
extends BaseBrokerProvider
implements PageProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerPageProvider.class);
    private static final Map<Integer, WebPageMetaFactory> WEB_PAGE_META_FACTORIES = new ConcurrentHashMap<Integer, WebPageMetaFactory>();
    private static final PageContentRetriever PAGE_CONTENT_RETRIEVER = new PageContentRetrieverImpl();

    public PageProviderResultItem<String> getPageById(int id, int publication) throws IOException, ItemNotFoundException, SerializationException {
        PageMeta pageMeta = this.getPageMetaById(id, publication);
        PageResultItemImpl pageResult = new PageResultItemImpl(pageMeta.getPublicationId(), pageMeta.getId(), pageMeta.getURLPath());
        pageResult.setLastPublishDate(pageMeta.getLastPublicationDate());
        pageResult.setRevisionDate(pageMeta.getModificationDate());
        pageResult.setContentSource((Object)this.getPageContentById(id, publication));
        return pageResult;
    }

    public PageProviderResultItem<String> getPageByURL(String url, int publication) throws ItemNotFoundException, SerializationException {
        PageMeta pageMeta = this.getPageMetaByURL(url, publication);
        PageResultItemImpl pageResult = new PageResultItemImpl(pageMeta.getPublicationId(), pageMeta.getId(), pageMeta.getURLPath());
        pageResult.setLastPublishDate(pageMeta.getLastPublicationDate());
        pageResult.setRevisionDate(pageMeta.getModificationDate());
        pageResult.setContentSource((Object)this.getPageContentById(pageMeta.getId(), pageMeta.getPublicationId()));
        return pageResult;
    }

    public String getPageContentById(int id, int publication) throws ItemNotFoundException, SerializationException {
        CharacterData data = PAGE_CONTENT_RETRIEVER.getPageContent(publication, id);
        if (data == null) {
            throw new ItemNotFoundException("Unable to find page by id '" + id + "' and publication '" + publication + "'.");
        }
        try {
            return this.decodeAndDecompressContent(BrokerPageProvider.convertStreamToString((InputStream)data.getInputStream()));
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public String getPageContentByURL(String url, int publication) throws ItemNotFoundException, SerializationException {
        PageMeta meta = this.getPageMetaByURL(url, publication);
        return this.getPageContentById(meta.getId(), meta.getPublicationId());
    }

    public String getPageContentById(String tcmUri) throws ItemNotFoundException, ParseException, SerializationException {
        TCMURI uri = new TCMURI(tcmUri);
        return this.getPageContentById(uri.getItemId(), uri.getPublicationId());
    }

    public String getPageListByPublicationId(int publication) throws ItemNotFoundException {
        throw new NotImplementedException();
    }

    protected static WebPageMetaFactory getWebPageMetaFactory(int publication) {
        WebPageMetaFactory webPageMetaFactory = WEB_PAGE_META_FACTORIES.get(publication);
        if (webPageMetaFactory == null) {
            webPageMetaFactory = new WebPageMetaFactoryImpl(publication);
            WEB_PAGE_META_FACTORIES.put(publication, webPageMetaFactory);
        }
        return webPageMetaFactory;
    }

    public PageMeta getPageMetaById(int id, int publication) throws ItemNotFoundException {
        WebPageMetaFactory webPageMetaFactory = BrokerPageProvider.getWebPageMetaFactory(publication);
        PageMeta pageMeta = webPageMetaFactory.getMeta(id);
        if (pageMeta == null) {
            throw new ItemNotFoundException("Unable to find page by id '" + id + "' and publication '" + publication + "'.");
        }
        return pageMeta;
    }

    public PageMeta getPageMetaByURL(String url, int publication) throws ItemNotFoundException {
        WebPageMetaFactory webPageMetaFactory = BrokerPageProvider.getWebPageMetaFactory(publication);
        PageMeta pageMeta = webPageMetaFactory.getMetaByURL(publication, url);
        if (pageMeta == null) {
            throw new ItemNotFoundException("Unable to find page by url '" + url + "' and publication '" + publication + "'.");
        }
        return pageMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPageExists(String url, int publicationId) throws ItemNotFoundException, SerializationException {
        LOG.debug("Checking whether Page with url: {} exists", (Object)url);
        String key = this.getKey(CacheType.PAGE_EXISTS, url);
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(key);
        Integer result = 0;
        if (cacheElement.isExpired()) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    TCMURI tcmuri = null;
                    try {
                        PageMeta pageMeta = this.getPageMetaByURL(url, publicationId);
                        if (pageMeta != null) {
                            result = 1;
                            tcmuri = new TCMURI(pageMeta.getPublicationId(), pageMeta.getId(), pageMeta.getType());
                        }
                    }
                    catch (ItemNotFoundException e) {
                        LOG.trace(String.format("Page with url:%s does not seem to exist.", url), (Throwable)e);
                    }
                    if (result == 1) {
                        cacheElement.setPayload((Object)result);
                        this.cacheProvider.storeInItemCache(key, cacheElement, tcmuri.getPublicationId(), tcmuri.getItemId());
                        cacheElement.setExpired(false);
                    } else {
                        result = 0;
                        cacheElement.setPayload((Object)result);
                        this.cacheProvider.storeInItemCache(key, cacheElement);
                        cacheElement.setExpired(false);
                    }
                    LOG.debug("Stored Page exist check with key: {} in cache", (Object)key);
                } else {
                    LOG.debug("Fetched a Page exist check with key: {} from cache", (Object)key);
                    result = (Integer)cacheElement.getPayload();
                }
            }
        }
        LOG.debug("Fetched Page exist check with key: {} from cache", (Object)key);
        result = (Integer)cacheElement.getPayload();
        return result != null && result == 1;
    }

    public TCMURI getPageIdForUrl(String url, int publicationId) throws ItemNotFoundException, SerializationException {
        PageMeta pageMeta = this.getPageMetaByURL(url, publicationId);
        if (pageMeta != null) {
            return new TCMURI(publicationId, pageMeta.getId(), pageMeta.getType(), pageMeta.getMajorVersion());
        }
        throw new ItemNotFoundException("Page Id for URL not found.");
    }

    public DateTime getLastPublishDate(String url, int publication) throws ItemNotFoundException {
        PageMeta pageMeta = this.getPageMetaByURL(url, publication);
        Date lpd = pageMeta.getLastPublicationDate();
        return lpd != null ? new DateTime((Object)lpd) : Constants.THE_YEAR_ZERO;
    }
}

