/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.providers.impl;

import com.sdl.web.api.linking.ComponentLinkImpl;
import com.sdl.web.api.linking.Link;
import com.tridion.util.TCMURI;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.providers.BaseBrokerProvider;
import org.dd4t.providers.LinkProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerLinkProvider
extends BaseBrokerProvider
implements LinkProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerLinkProvider.class);

    public String resolveComponent(String targetComponentURI) {
        try {
            TCMURI componentURI = new TCMURI(targetComponentURI);
            ComponentLinkImpl componentLink = new ComponentLinkImpl(componentURI.getPublicationId());
            Link link = componentLink.getLink(componentURI.getItemId());
            if (link.isResolved()) {
                return link.getURL();
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to resolve link to " + targetComponentURI + ": " + ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public String resolveComponentFromPage(String targetComponentURI, String sourcePageURI) {
        String link = BrokerLinkProvider.getLinkAsString(sourcePageURI, targetComponentURI, "tcm:0-0-0");
        if (StringUtils.isNotEmpty((CharSequence)link)) {
            return link;
        }
        return null;
    }

    public String resolveComponent(String targetComponentUri, String excludeComponentTemplateUri) throws ItemNotFoundException, SerializationException {
        String link = BrokerLinkProvider.getLinkAsString("tcm:0-0-0", targetComponentUri, excludeComponentTemplateUri);
        if (StringUtils.isNotEmpty((CharSequence)link)) {
            return link;
        }
        return null;
    }

    private static String getLinkAsString(String sourcePageUri, String targetComponentUri, String componentTemplateUri) {
        try {
            TCMURI componentURI = new TCMURI(targetComponentUri);
            ComponentLinkImpl componentLink = new ComponentLinkImpl(componentURI.getPublicationId());
            Link link = componentLink.getLink(sourcePageUri, targetComponentUri, componentTemplateUri, "", "", true, false);
            if (link.isResolved()) {
                return link.getURL();
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to resolve link to " + targetComponentUri + ": " + ex.getMessage(), (Throwable)ex);
        }
        return null;
    }
}

