/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.providers.impl;

import com.sdl.web.api.broker.WebComponentPresentationFactoryImpl;
import com.sdl.web.api.dynamic.WebComponentPresentationFactory;
import com.tridion.dcp.ComponentPresentation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.providers.AbstractComponentPresentationProvider;
import org.dd4t.providers.ComponentPresentationProvider;
import org.dd4t.providers.ComponentPresentationResultItem;
import org.dd4t.providers.ComponentPresentationResultItemImpl;

public class BrokerComponentPresentationProvider
extends AbstractComponentPresentationProvider
implements ComponentPresentationProvider {
    private static final Map<Integer, WebComponentPresentationFactory> FACTORY_CACHE = new ConcurrentHashMap<Integer, WebComponentPresentationFactory>();

    public String getDynamicComponentPresentation(int componentId, int publicationId) throws ItemNotFoundException, SerializationException {
        return this.getDynamicComponentPresentation(componentId, 0, publicationId);
    }

    public String getDynamicComponentPresentation(int componentId, int templateId, int publicationId) throws ItemNotFoundException, SerializationException {
        ComponentPresentation result = this.getComponentPresentation(componentId, templateId, publicationId);
        String resultString = result.getContent();
        if (!StringUtils.isEmpty((CharSequence)resultString)) {
            return this.decodeAndDecompressContent(resultString);
        }
        return null;
    }

    public ComponentPresentationResultItem<String> getDynamicComponentPresentationItem(int componentId, int publicationId) throws ItemNotFoundException, SerializationException {
        return this.getDynamicComponentPresentationItem(componentId, 0, publicationId);
    }

    public ComponentPresentationResultItem<String> getDynamicComponentPresentationItem(int componentId, int templateId, int publicationId) throws ItemNotFoundException, SerializationException {
        ComponentPresentationResultItemImpl resultModel;
        ComponentPresentation result = this.getComponentPresentation(componentId, templateId, publicationId);
        if (result != null) {
            resultModel = new ComponentPresentationResultItemImpl(result.getPublicationId(), result.getComponentId(), result.getComponentTemplateId());
            BrokerComponentPresentationProvider.assertQueryResultNotNull((Object)result, (int)componentId, (int)templateId, (int)publicationId);
            String resultString = result.getContent();
            if (!StringUtils.isEmpty((CharSequence)resultString)) {
                resultModel.setContentSource(this.decodeAndDecompressContent(resultString));
            } else {
                resultModel.setContentSource(resultString);
            }
        } else {
            resultModel = new ComponentPresentationResultItemImpl(0, 0, 0);
        }
        return resultModel;
    }

    protected ComponentPresentation getComponentPresentation(int componentId, int templateId, int publicationId) throws ItemNotFoundException {
        WebComponentPresentationFactory factory = FACTORY_CACHE.get(publicationId);
        if (factory == null) {
            factory = new WebComponentPresentationFactoryImpl(publicationId);
            FACTORY_CACHE.put(publicationId, factory);
        }
        ComponentPresentation result = templateId != 0 ? factory.getComponentPresentation(componentId, templateId) : factory.getComponentPresentationWithHighestPriority(componentId);
        BrokerComponentPresentationProvider.assertQueryResultNotNull((Object)result, (int)componentId, (int)templateId, (int)publicationId);
        return result;
    }
}

