/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.providers.impl;

import com.sdl.web.api.content.BinaryContentRetriever;
import com.sdl.web.api.dynamic.BinaryContentRetrieverImpl;
import com.sdl.web.api.meta.WebBinaryMetaFactory;
import com.sdl.web.api.meta.WebBinaryMetaFactoryImpl;
import com.sdl.web.api.meta.WebComponentMetaFactory;
import com.sdl.web.api.meta.WebComponentMetaFactoryImpl;
import com.tridion.meta.BinaryMeta;
import com.tridion.meta.ComponentMeta;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.contentmodel.Binary;
import org.dd4t.contentmodel.BinaryData;
import org.dd4t.contentmodel.impl.BinaryDataImpl;
import org.dd4t.contentmodel.impl.BinaryImpl;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.core.util.Constants;
import org.dd4t.core.util.TCMURI;
import org.dd4t.providers.BaseBrokerProvider;
import org.dd4t.providers.BinaryProvider;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerBinaryProvider
extends BaseBrokerProvider
implements BinaryProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerBinaryProvider.class);
    private static final BinaryContentRetriever BINARY_CONTENT_RETRIEVER = new BinaryContentRetrieverImpl();
    private static final WebBinaryMetaFactory WEB_BINARY_META_FACTORY = new WebBinaryMetaFactoryImpl();
    private static final Map<Integer, WebComponentMetaFactory> FACTORY_CACHE = new ConcurrentHashMap<Integer, WebComponentMetaFactory>();

    public Binary getBinaryByURI(String tcmUri) throws ItemNotFoundException, ParseException, SerializationException {
        TCMURI binaryUri = new TCMURI(tcmUri);
        BinaryMeta binaryMeta = this.getBinaryMetaByTcmUri(binaryUri);
        return this.getBinary(binaryUri, binaryMeta);
    }

    public Binary getBinaryByURL(String url, int publication) throws ItemNotFoundException, SerializationException {
        BinaryMeta binaryMeta = this.getBinaryMetaByURL(url, publication);
        TCMURI binaryUri = new TCMURI(binaryMeta.getPublicationId(), (int)binaryMeta.getId(), 16);
        return this.getBinary(binaryUri, binaryMeta);
    }

    private Binary getBinary(TCMURI binaryUri, BinaryMeta binaryMeta) throws ItemNotFoundException {
        BinaryImpl binary = new BinaryImpl();
        binary.setId(binaryUri.toString());
        binary.setUrlPath(binaryMeta.getURLPath());
        binary.setMimeType(binaryMeta.getType());
        binary.setLastPublishedDate(this.getLastPublishDate(binaryUri.toString()));
        BinaryDataImpl binaryDataBytes = new BinaryDataImpl();
        binaryDataBytes.setBytes(this.getBinaryContentById(binaryUri.getItemId(), binaryUri.getPublicationId()));
        binary.setBinaryData((BinaryData)binaryDataBytes);
        return binary;
    }

    public byte[] getBinaryContentById(int id, int publication) throws ItemNotFoundException {
        com.tridion.data.BinaryData binaryData = BINARY_CONTENT_RETRIEVER.getBinary(publication, id);
        if (binaryData == null || binaryData.getDataSize() == 0L) {
            throw new ItemNotFoundException("Unable to find binary content by id: tcm:" + publication + "-" + id);
        }
        try {
            return (byte[])binaryData.getBytes().clone();
        }
        catch (IOException e) {
            throw new ItemNotFoundException((Throwable)e);
        }
    }

    public byte[] getBinaryContentByURL(String url, int publication) throws ItemNotFoundException {
        BinaryMeta binaryMeta = this.getBinaryMetaByURL(url, publication);
        return this.getBinaryContentById((int)binaryMeta.getId(), binaryMeta.getPublicationId());
    }

    public com.tridion.data.BinaryData getBinaryDataById(int id, int publication) throws ItemNotFoundException {
        return this.getBinaryDataById(id, publication, null);
    }

    public com.tridion.data.BinaryData getBinaryDataById(int id, int publication, String variantId) throws ItemNotFoundException {
        com.tridion.data.BinaryData binaryData = StringUtils.isEmpty((CharSequence)variantId) ? BINARY_CONTENT_RETRIEVER.getBinary(publication, id) : BINARY_CONTENT_RETRIEVER.getBinary(publication, id, variantId);
        if (binaryData == null) {
            throw new ItemNotFoundException("Unable to find binary by id '" + id + "' and publication '" + publication + "'.");
        }
        return binaryData;
    }

    public BinaryMeta getBinaryMetaByURL(String url, int publication) throws ItemNotFoundException {
        BinaryMeta binaryMeta = WEB_BINARY_META_FACTORY.getMetaByURL(publication, url);
        if (binaryMeta == null) {
            throw new ItemNotFoundException("Unable to find binary by url '" + url + "' and publication '" + publication + "'.");
        }
        return binaryMeta;
    }

    public BinaryMeta getBinaryMetaById(int publicationId, int itemId) throws ItemNotFoundException {
        TCMURI binaryUri = new TCMURI(publicationId, itemId, 16);
        return this.getBinaryMetaByTcmUri(binaryUri);
    }

    public BinaryMeta getBinaryMetaByTcmUri(TCMURI binaryUri) throws ItemNotFoundException {
        BinaryMeta binaryMeta = WEB_BINARY_META_FACTORY.getMeta(binaryUri.toString());
        if (binaryMeta == null) {
            throw new ItemNotFoundException("Unable to find binary by TCMURI '" + binaryUri.toString());
        }
        return binaryMeta;
    }

    public DateTime getLastPublishDate(String tcmUri) throws ItemNotFoundException {
        ComponentMeta binaryMeta;
        TCMURI binaryTcmUri = null;
        try {
            binaryTcmUri = new TCMURI(tcmUri);
        }
        catch (ParseException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        if (binaryTcmUri == null) {
            return Constants.THE_YEAR_ZERO;
        }
        WebComponentMetaFactory webComponentMetaFactory = FACTORY_CACHE.get(binaryTcmUri.getPublicationId());
        if (webComponentMetaFactory == null) {
            webComponentMetaFactory = new WebComponentMetaFactoryImpl(binaryTcmUri.getPublicationId());
            FACTORY_CACHE.put(binaryTcmUri.getPublicationId(), webComponentMetaFactory);
        }
        if ((binaryMeta = webComponentMetaFactory.getMeta(tcmUri)) != null && binaryMeta.getLastPublicationDate() != null) {
            return new DateTime((Object)binaryMeta.getLastPublicationDate());
        }
        return Constants.THE_YEAR_ZERO;
    }
}

