/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.util;

import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;

public class XSLTransformer {
    private static final XSLTransformer INSTANCE = new XSLTransformer();
    private static final Map<String, Templates> CACHE = new ConcurrentHashMap<String, Templates>();

    private XSLTransformer() {
        String key = "javax.xml.transform.TransformerFactory";
        String value = "org.apache.xalan.xsltc.trax.SmartTransformerFactoryImpl";
        Properties props = System.getProperties();
        props.put(key, value);
        System.setProperties(props);
    }

    public static XSLTransformer getInstance() {
        return INSTANCE;
    }

    public String transformSourceFromFilesource(String source, String resource, Map<String, Object> params) throws TransformerException {
        CharArrayWriter caw = new CharArrayWriter();
        StreamResult result = new StreamResult(caw);
        Transformer trans = this.getTransformer(resource);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            trans.setParameter(entry.getKey(), entry.getValue());
        }
        if (trans != null) {
            StringReader reader = new StringReader(source);
            StreamSource xmlSource = new StreamSource(reader);
            trans.transform(xmlSource, result);
        }
        return caw.toString();
    }

    public String transformSourceFromFilesource(String source, String resource) throws TransformerException {
        return this.transformSourceFromFilesource(source, resource, new HashMap<String, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Transformer getTransformer(String resource) throws TransformerConfigurationException {
        Transformer trans = null;
        Templates temp = null;
        if (CACHE.containsKey(resource)) {
            temp = CACHE.get(resource);
            return temp.newTransformer();
        }
        InputStream stream = null;
        try {
            stream = this.getClass().getResourceAsStream(resource);
            if (null == stream) {
                throw new TransformerConfigurationException("Resource '" + resource + "' could not be loaded. ");
            }
            StreamSource source = new StreamSource(stream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            temp = transformerFactory.newTemplates(source);
            CACHE.put(resource, temp);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return temp.newTransformer();
    }
}

