/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.util;

import java.text.ParseException;
import org.dd4t.contentmodel.Component;
import org.dd4t.contentmodel.Schema;
import org.dd4t.core.request.RequestContext;
import org.dd4t.core.util.HttpUtils;
import org.dd4t.core.util.TCMURI;

public class TridionUtils {
    public static final String TCM_REGEX = "(tcm:[0-9]+-[0-9]+(-[0-9]+)?)";
    public static final String PREVIEW_SESSION_TOKEN = "preview-session-token";

    private TridionUtils() {
    }

    public static int extractPublicationIdFromTcmUri(String tcmUri) throws ParseException {
        TCMURI fullTcmUri = new TCMURI(tcmUri);
        return fullTcmUri.getItemId();
    }

    public static String constructFullTcmPublicationUri(int id) {
        return TridionUtils.constructFullTcmPublicationUri(String.valueOf(id));
    }

    public static String constructFullTcmPublicationUri(String id) {
        return String.format("tcm:0-%s-1", id);
    }

    public static String getSessionPreviewToken() {
        return HttpUtils.getSessionPreviewToken(HttpUtils.getCurrentRequest());
    }

    public static String getSessionPreviewToken(RequestContext context) {
        if (context == null) {
            return null;
        }
        return HttpUtils.getSessionPreviewToken(context.getServletRequest());
    }

    public static String getRootElementName(Component component) {
        Schema schema = component.getSchema();
        return null != component.getMultimedia() ? schema.getTitle() : schema.getRootElement();
    }
}

