/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.contentmodel.impl.XhtmlField;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.core.resolvers.LinkResolver;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class RichTextUtils {
    private static final Pattern TCM = Pattern.compile("^tcm:");
    private static final String XLINK_HREF = "xlink:href";
    private static final String XHTMLBODYROOT = "xhtmlbodyroot";
    private static final String IMG_TAG = "img";
    private static final String SRC_ATTR = "src";

    private RichTextUtils() {
    }

    public static String resolveXhtmlBody(String body, boolean resolveLinks, LinkResolver linkResolver, String contextPath) throws ItemNotFoundException, SerializationException {
        return RichTextUtils.doReplacement(RichTextUtils.resolveXhtml(resolveLinks, linkResolver, contextPath, body));
    }

    public static void resolveXhtmlField(XhtmlField xhtmlFields, boolean resolveLinks, LinkResolver linkResolver, String contextPath) throws ItemNotFoundException, SerializationException {
        List<Object> xhtmlValues = xhtmlFields.getValues();
        ArrayList<String> newValues = new ArrayList<String>();
        String contextPathToUse = contextPath == null ? "" : contextPath;
        for (Object xhtmlField : xhtmlValues) {
            if (StringUtils.isEmpty((CharSequence)((String)xhtmlField))) {
                newValues.add("");
                continue;
            }
            Element xhtmlBodyRoot = RichTextUtils.resolveXhtml(resolveLinks, linkResolver, contextPathToUse, (String)xhtmlField);
            if (xhtmlBodyRoot == null) continue;
            newValues.add(RichTextUtils.doReplacement(xhtmlBodyRoot));
        }
        xhtmlFields.setTextValues(newValues);
    }

    protected static String doReplacement(Element xhtmlBodyRoot) {
        return xhtmlBodyRoot.html().replaceAll("(?ims)xlink:|xmlns(=\"http://www\\.w3\\.org/1999/xhtml\"\\s*|:xlink=\"http://www\\.w3\\.org/1999/xlink\"\\s*)", "");
    }

    protected static Element resolveXhtml(boolean resolveLinks, LinkResolver linkResolver, String contextPathToUse, String xhtmlField) throws SerializationException, ItemNotFoundException {
        Document document = Jsoup.parseBodyFragment((String)("<xhtmlbodyroot>" + xhtmlField + "</" + XHTMLBODYROOT + ">"));
        document.outputSettings().indentAmount(0).prettyPrint(false);
        Element xhtmlBodyRoot = document.getElementsByTag(XHTMLBODYROOT).first();
        if (resolveLinks && linkResolver != null) {
            Elements links = xhtmlBodyRoot.getElementsByAttributeValueMatching(XLINK_HREF, TCM);
            for (Element link : links) {
                String resolvedLink = linkResolver.resolve(link.attr(XLINK_HREF));
                if (StringUtils.isNotEmpty((CharSequence)resolvedLink)) {
                    link.attr(XLINK_HREF, contextPathToUse + resolvedLink);
                    continue;
                }
                if (link.hasAttr("href")) {
                    link.removeAttr(XLINK_HREF);
                    continue;
                }
                link.attr(XLINK_HREF, "");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)contextPathToUse)) {
            Elements images = xhtmlBodyRoot.getElementsByTag(IMG_TAG);
            for (Element image : images) {
                String src = image.attr(SRC_ATTR);
                image.attr(SRC_ATTR, contextPathToUse + src);
            }
        }
        return xhtmlBodyRoot;
    }
}

