/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.util;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class HttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    public static ServletContext getCurrentServletContext() {
        return HttpUtils.getCurrentRequest().getServletContext();
    }

    public static String getOriginalUri(HttpServletRequest request) {
        String orgUri = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (StringUtils.isNotEmpty((CharSequence)orgUri)) {
            return orgUri;
        }
        return request.getRequestURI();
    }

    public static String getCurrentURL(HttpServletRequest request, boolean stripContextPath) {
        DispatcherType dispatcherType = request.getDispatcherType();
        String url = dispatcherType == DispatcherType.ERROR ? request.getRequestURI() : (dispatcherType == DispatcherType.INCLUDE ? (String)request.getAttribute("javax.servlet.include.request_uri") : HttpUtils.getOriginalUri(request));
        return stripContextPath ? url.substring(HttpUtils.getContextPath(request).length()) : url;
    }

    public static String getOriginalFullUrl(HttpServletRequest request, boolean stripContextPath) {
        return HttpUtils.getFullUrl(request, HttpUtils.getOriginalUri(request), stripContextPath);
    }

    public static String getFullUrl(HttpServletRequest request, String location, boolean stripContextPath) {
        String contextPath = HttpUtils.getContextPath(request);
        return String.format("%s://%s:%d%s", request.getScheme(), request.getServerName(), request.getServerPort(), stripContextPath ? location.substring(contextPath.length()) : location);
    }

    protected static String getContextPath(HttpServletRequest request) {
        return "/".equals(request.getContextPath()) ? "" : request.getContextPath();
    }

    public static HttpServletRequest getCurrentRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
    }

    public static String createPathFromUri(String uri, int level) {
        StringBuilder searchPath = new StringBuilder("");
        String[] paths = uri.split("/");
        int count = 0;
        for (int i = 0; i < paths.length && count < level; ++i) {
            String path = paths[i];
            if (StringUtils.isEmpty((CharSequence)path) || i == paths.length - 1 && path.indexOf(46) >= 0) continue;
            searchPath.append("/");
            searchPath.append(path);
            ++count;
        }
        return searchPath.length() == 0 ? "/" : searchPath.toString();
    }

    private static String getClientIP(HttpServletRequest request) {
        String s = request.getHeader("HTTP_X_FORWARDED_FOR");
        String clientIP = null != s ? s.split(",")[0] : request.getRemoteAddr();
        return clientIP;
    }

    public static boolean isLocalDomainRequest(HttpServletRequest request) throws UnknownHostException {
        return HttpUtils.isLocalDomainAddress(HttpUtils.getClientIP(request));
    }

    private static boolean isLocalDomainAddress(String ipAddress) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(ipAddress);
        return inetAddress.isAnyLocalAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isMulticastAddress() || inetAddress.isSiteLocalAddress();
    }

    public static String getContentTypeByExtension(String url) {
        String extension = url.substring(url.lastIndexOf(46) + 1);
        if ("txt".equalsIgnoreCase(extension)) {
            return "text/plain";
        }
        if ("xml".equalsIgnoreCase(extension)) {
            return "text/xml";
        }
        return "text/html";
    }

    public static void appendAttribute(StringBuilder sb, String name, String value) {
        HttpUtils.appendAttribute(sb, name, value, true);
    }

    public static void appendAttribute(StringBuilder sb, String name, String value, boolean suppressIfEmpty) {
        String attributeValue = "";
        if (value != null) {
            attributeValue = value;
        }
        if (!suppressIfEmpty || attributeValue.length() > 0) {
            sb.append(' ').append(name).append("=\"").append(attributeValue).append('\"');
        }
    }

    public static List<NameValuePair> parseQueryParams(String queryString) {
        if (StringUtils.isEmpty((CharSequence)queryString)) {
            return Collections.emptyList();
        }
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        for (String param : queryString.split("&")) {
            String[] paramParts = param.split("=");
            String name = paramParts[0];
            String value = paramParts.length == 2 ? paramParts[1] : "";
            result.add((NameValuePair)new BasicNameValuePair(name, value));
        }
        return result;
    }

    public static URI parseUri(String uriStr) {
        if (StringUtils.isEmpty((CharSequence)uriStr)) {
            return null;
        }
        try {
            return new URI(uriStr);
        }
        catch (URISyntaxException e) {
            LOG.warn("Could not parse URI: {}", (Object)uriStr, (Object)e);
            return null;
        }
    }

    public static Cookie findCookieByName(String name) {
        HttpServletRequest request = HttpUtils.getCurrentRequest();
        if (request == null) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String appendDefaultPageIfRequired(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        String ext = FilenameUtils.getExtension((String)url);
        if (StringUtils.isEmpty((CharSequence)ext)) {
            url = url.endsWith("/") ? url + "index.html" : url + "/index.html";
        }
        return url;
    }

    public static String normalizeUrl(String url) {
        return url == null ? null : url.replaceAll("//+", "/");
    }

    public static String removeNonAlphaNumeric(String key) {
        return HttpUtils.replaceNonAlphaNumeric(key, "");
    }

    public static String replaceNonAlphaNumeric(String key, String replacement) {
        if (key == null) {
            return "";
        }
        if (replacement == null) {
            replacement = "";
        }
        return key.replaceAll("\\W+", replacement);
    }

    public static String getSessionPreviewToken(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"preview-session-token".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

