/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.dd4t.core.exceptions.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CompressionUtils.class);

    private CompressionUtils() {
    }

    public static <T> byte[] compressGZipGeneric(T object) throws SerializationException {
        byte[] byArray;
        ByteArrayOutputStream baos = null;
        GZIPOutputStream gos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            gos = new GZIPOutputStream(baos);
            oos = new ObjectOutputStream(gos);
            oos.writeObject(object);
            gos.close();
            byArray = baos.toByteArray();
        }
        catch (IOException ioe) {
            try {
                LOG.error("Compression failed.", (Throwable)ioe);
                throw new SerializationException("Failed to compres object", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(oos);
                IOUtils.closeQuietly(gos);
                IOUtils.closeQuietly((OutputStream)baos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)oos);
        IOUtils.closeQuietly((OutputStream)gos);
        IOUtils.closeQuietly((OutputStream)baos);
        return byArray;
    }

    public static byte[] compressGZip(String content) throws SerializationException {
        byte[] byArray;
        ByteArrayOutputStream baos = null;
        GZIPOutputStream gos = null;
        try {
            baos = new ByteArrayOutputStream();
            gos = new GZIPOutputStream(baos);
            gos.write(content.getBytes("UTF-8"));
            gos.close();
            byArray = baos.toByteArray();
        }
        catch (IOException ioe) {
            try {
                LOG.error("String compression failed.", (Throwable)ioe);
                throw new SerializationException("Failed to compress String", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gos);
                IOUtils.closeQuietly((OutputStream)baos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)gos);
        IOUtils.closeQuietly((OutputStream)baos);
        return byArray;
    }

    public static <T> T decompressGZipGeneric(byte[] bytes) throws SerializationException {
        Object result = null;
        ByteArrayInputStream bais = null;
        GZIPInputStream gis = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            gis = new GZIPInputStream(bais);
            ois = new ObjectInputStream(gis);
            result = ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            try {
                LOG.error("Decompression failed.", (Throwable)e);
                throw new SerializationException("Object failed decompression", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                IOUtils.closeQuietly(gis);
                IOUtils.closeQuietly((InputStream)bais);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        IOUtils.closeQuietly((InputStream)gis);
        IOUtils.closeQuietly((InputStream)bais);
        return (T)result;
    }

    public static String decompressGZip(byte[] bytes) throws SerializationException {
        String result = null;
        ByteArrayInputStream bais = null;
        GZIPInputStream gis = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            gis = new GZIPInputStream(bais);
            result = IOUtils.toString((InputStream)gis);
        }
        catch (IOException ioe) {
            try {
                LOG.error("Decompression failed.", (Throwable)ioe);
                throw new SerializationException("Failed to decompress byte array", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gis);
                IOUtils.closeQuietly((InputStream)bais);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)gis);
        IOUtils.closeQuietly((InputStream)bais);
        return result;
    }

    public static String encodeBase64(byte[] byteArray) {
        return Base64.encodeBase64String((byte[])byteArray);
    }

    public static String encodeBase64(String message) {
        if (message == null) {
            return null;
        }
        return CompressionUtils.encodeBase64(message.getBytes(Charset.forName("UTF-8")));
    }

    public static byte[] decodeBase64(String message) {
        byte[] result;
        if (Base64.isBase64((String)message)) {
            return Base64.decodeBase64((String)message);
        }
        try {
            result = message.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.error(uee.getLocalizedMessage(), (Throwable)uee);
            result = message.getBytes();
        }
        return result;
    }
}

