/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.serializers.impl.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.IOException;
import org.dd4t.contentmodel.Field;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.core.serializers.Serializer;
import org.dd4t.databind.serializers.json.BaseFieldMixIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONSerializer
implements Serializer {
    private static final Logger LOG = LoggerFactory.getLogger(JSONSerializer.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public <T> T deserialize(String content, Class<T> aClass) throws SerializationException {
        try {
            return (T)MAPPER.readValue(content, aClass);
        }
        catch (IOException e) {
            LOG.error("Error deserializing.", (Throwable)e);
            throw new SerializationException((Throwable)e);
        }
    }

    public String serialize(Object item) throws SerializationException {
        try {
            LOG.debug("Serializing a {}", item.getClass());
            return MAPPER.writeValueAsString(item);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error serializing.", (Throwable)e);
            throw new SerializationException((Throwable)e);
        }
    }

    static {
        MAPPER.registerModule((Module)new JodaModule());
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        MAPPER.addMixIn(Field.class, BaseFieldMixIn.class);
        MAPPER.registerModule((Module)new AfterburnerModule());
    }
}

