/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.serializers.impl;

import javax.annotation.Resource;
import org.dd4t.contentmodel.Binary;
import org.dd4t.contentmodel.BinaryData;
import org.dd4t.contentmodel.impl.BinaryDataImpl;
import org.dd4t.contentmodel.impl.BinaryImpl;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.core.serializers.Serializer;
import org.dd4t.core.util.CompressionUtils;
import org.dd4t.providers.transport.BinaryWrapper;

public class BinaryBuilder {
    @Resource
    protected Serializer serializer;

    public Binary build(BinaryWrapper wrapper) throws SerializationException {
        byte[] binaryBytes = CompressionUtils.decodeBase64(wrapper.getBinary());
        String binaryJSON = CompressionUtils.decompressGZip(binaryBytes);
        Binary result = (Binary)this.serializer.deserialize(binaryJSON, BinaryImpl.class);
        BinaryDataImpl binaryData = new BinaryDataImpl();
        binaryData.setBytes(wrapper.getContent());
        result.setBinaryData((BinaryData)binaryData);
        return result;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }
}

