/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.resolvers.impl;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.contentmodel.PublicationDescriptor;
import org.dd4t.core.resolvers.PublicationResolver;
import org.dd4t.core.util.HttpUtils;
import org.dd4t.providers.PublicationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlPublicationResolver
implements PublicationResolver {
    private static final Logger LOG = LoggerFactory.getLogger(UrlPublicationResolver.class);
    @Resource
    private PublicationProvider publicationProvider;
    private boolean useCdDynamic;
    private boolean stripServletContextPath;

    public int getPublicationId() {
        HttpServletRequest request = HttpUtils.getCurrentRequest();
        if (this.useCdDynamic) {
            LOG.debug("Using cd_dynamic_conf.xml to determine publication Id");
            return this.publicationProvider.discoverPublicationByBaseUrl(HttpUtils.appendDefaultPageIfRequired(HttpUtils.getOriginalFullUrl(request, this.stripServletContextPath)));
        }
        LOG.debug("Determining Pub Id on page URL.");
        return this.publicationProvider.discoverPublicationIdByPageUrlPath(HttpUtils.appendDefaultPageIfRequired(HttpUtils.getOriginalFullUrl(request, this.stripServletContextPath)));
    }

    public int discoverPublicationIdByImagesUrl(String imagesUrl) {
        HttpServletRequest request = HttpUtils.getCurrentRequest();
        if (this.useCdDynamic) {
            LOG.debug("Using cd_dynamic_conf.xml to determine publication Id");
            return this.publicationProvider.discoverPublicationByBaseUrl(HttpUtils.appendDefaultPageIfRequired(HttpUtils.getOriginalFullUrl(request, this.stripServletContextPath)));
        }
        LOG.debug("Determining Pub Id on Images URL: {}.", (Object)imagesUrl);
        return this.publicationProvider.discoverPublicationByImagesUrl(HttpUtils.getOriginalFullUrl(request, this.stripServletContextPath));
    }

    public String getPublicationUrl() {
        return this.publicationProvider.discoverPublicationUrl(this.getPublicationId());
    }

    public String getPublicationPath() {
        return this.publicationProvider.discoverPublicationPath(this.getPublicationId());
    }

    public String getImagesUrl() {
        return this.publicationProvider.discoverImagesUrl(this.getPublicationId());
    }

    public String getImagesPath() {
        return this.publicationProvider.discoverImagesPath(this.getPublicationId());
    }

    public String getLocalPageUrl(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        String publicationUrl = this.publicationProvider.discoverPublicationUrl(this.getPublicationId());
        if (StringUtils.isNotEmpty((CharSequence)publicationUrl) && !url.startsWith(publicationUrl)) {
            return String.format("%s%s", publicationUrl, url.startsWith("/") ? url : "/" + url);
        }
        return url;
    }

    public String getLocalBinaryUrl(String url) {
        String binaryUrl = this.publicationProvider.discoverImagesUrl(this.getPublicationId());
        return url.replaceFirst(binaryUrl, "");
    }

    public PublicationDescriptor getPublicationDescriptor() {
        return this.publicationProvider.getPublicationDescriptor(this.getPublicationId());
    }

    public void setPublicationProvider(PublicationProvider publicationProvider) {
        this.publicationProvider = publicationProvider;
    }

    public void setUseCdDynamic(String useCdDynamicValue) {
        this.useCdDynamic = Boolean.parseBoolean(useCdDynamicValue);
    }

    public void setStripServletContextPath(boolean stripServletContextPath) {
        this.stripServletContextPath = stripServletContextPath;
    }
}

