/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.resolvers.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.caching.CacheElement;
import org.dd4t.contentmodel.Component;
import org.dd4t.contentmodel.ComponentPresentation;
import org.dd4t.contentmodel.Page;
import org.dd4t.contentmodel.Publication;
import org.dd4t.contentmodel.Schema;
import org.dd4t.contentmodel.impl.PublicationImpl;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.core.resolvers.LinkResolver;
import org.dd4t.core.util.TCMURI;
import org.dd4t.core.util.TridionUtils;
import org.dd4t.providers.LinkProvider;
import org.dd4t.providers.PayloadCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLinkResolver
implements LinkResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLinkResolver.class);
    @Resource
    private LinkProvider linkProvider;
    @Resource
    private PayloadCacheProvider cacheProvider;
    private Map<String, String> schemaToUrlMappings;
    private String schemaKey;
    private boolean encodeUrl = true;
    private String contextPath;

    public String resolve(ComponentPresentation cp) throws ItemNotFoundException, SerializationException {
        return this.resolve(cp.getComponent(), null);
    }

    public String resolve(Component component) throws ItemNotFoundException, SerializationException {
        return this.resolve(component, null);
    }

    public String resolve(Component component, Page page) throws ItemNotFoundException, SerializationException {
        LOG.debug("Resolving link to component: {} from page: {}", (Object)component, (Object)page);
        String resolvedUrl = null;
        if (component == null) {
            return null;
        }
        if (component.getMultimedia() != null) {
            resolvedUrl = component.getMultimedia().getUrl();
        }
        Schema schema = component.getSchema();
        if (resolvedUrl == null) {
            resolvedUrl = this.findUrlMapping(schema);
        }
        if (StringUtils.isEmpty((CharSequence)resolvedUrl)) {
            DefaultLinkResolver.verifyPublicationIsSet(component);
            resolvedUrl = page == null ? this.resolve(component.getId()) : this.resolve(component.getId(), page.getId());
            if (StringUtils.isEmpty((CharSequence)resolvedUrl)) {
                LOG.debug("Not possible to resolve url for component: " + component.getId());
            }
        } else {
            resolvedUrl = this.replacePlaceholders(resolvedUrl, "%COMPONENTURI%", component.getId());
            resolvedUrl = this.replacePlaceholders(resolvedUrl, "%COMPONENTTITLE%", component.getTitle());
            resolvedUrl = this.replacePlaceholders(resolvedUrl, "%SCHEMAURI%", schema.getId());
            resolvedUrl = this.replacePlaceholders(resolvedUrl, "%SCHEMATITLE%", schema.getTitle());
        }
        if (this.contextPath != null && this.contextPath.length() > 0) {
            resolvedUrl = this.contextPath + resolvedUrl;
        }
        component.setResolvedUrl(resolvedUrl);
        return resolvedUrl;
    }

    private static void verifyPublicationIsSet(Component component) {
        if (component.getPublication() == null) {
            try {
                TCMURI tcmUri = new TCMURI(component.getId());
                component.setPublication((Publication)new PublicationImpl(TridionUtils.constructFullTcmPublicationUri(tcmUri.getPublicationId())));
            }
            catch (ParseException e) {
                LOG.error("Problem parsing the uri for component: " + component.getId(), (Throwable)e);
            }
        }
    }

    public String resolve(String componentURI) throws ItemNotFoundException, SerializationException {
        return this.resolve(componentURI, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validInCache(CacheElement<String> cacheElement) {
        if (cacheElement.isExpired()) {
            CacheElement<String> cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    cacheElement.setExpired(false);
                    return false;
                }
            }
        }
        return true;
    }

    public String resolve(String componentURI, String pageURI) throws ItemNotFoundException, SerializationException {
        String result;
        String key = !StringUtils.isEmpty((CharSequence)pageURI) ? this.getCacheKey(componentURI, pageURI) : this.getCacheKey(componentURI);
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(key);
        if (!this.validInCache((CacheElement<String>)cacheElement)) {
            result = !StringUtils.isEmpty((CharSequence)pageURI) ? this.linkProvider.resolveComponentFromPage(componentURI, pageURI) : this.linkProvider.resolveComponent(componentURI);
            try {
                result = this.addToCache(componentURI, key, (CacheElement<String>)cacheElement, result);
            }
            catch (ParseException e) {
                String message = String.format("Invalid ComponentURI %s", componentURI);
                LOG.error(message);
                throw new SerializationException(message, (Throwable)e);
            }
        } else {
            result = (String)cacheElement.getPayload();
            LOG.debug("Return link url: {} for uri: {} from cache", (Object)result, (Object)componentURI);
        }
        return result;
    }

    private String addToCache(String componentURI, String key, CacheElement<String> cacheElement, String result) throws ParseException {
        result = result == null ? "" : result;
        cacheElement.setPayload((Object)result);
        TCMURI tcmUri = new TCMURI(componentURI);
        this.cacheProvider.storeInItemCache(key, cacheElement, tcmUri.getPublicationId(), tcmUri.getItemId());
        LOG.debug("Added link url: {} for uri: {} to cache", (Object)result, (Object)componentURI);
        return result;
    }

    private String getCacheKey(String componentURI) {
        return String.format("CL-%s", componentURI);
    }

    private String getCacheKey(String componentURI, String pageURI) {
        return String.format("CL-%s-%s", componentURI, pageURI);
    }

    private String replacePlaceholders(String resolvedUrl, String placeholder, String replacementText) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)replacementText)) {
            if (this.getEncodeUrl()) {
                try {
                    replacementText = URLEncoder.encode(replacementText, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn("Not possible to encode string: " + replacementText, (Throwable)e);
                    return "";
                }
            }
            Pattern p = Pattern.compile(placeholder);
            Matcher m = p.matcher(resolvedUrl);
            int pos = 0;
            while (m.find()) {
                sb.append(resolvedUrl, pos, m.start());
                pos = m.end();
                sb.append(replacementText);
            }
            sb.append(resolvedUrl, pos, resolvedUrl.length());
        }
        return sb.toString();
    }

    private String findUrlMapping(Schema schema) {
        String key = "";
        if ("id".equals(this.schemaKey)) {
            try {
                TCMURI tcmUri = new TCMURI(schema.getId());
                key = String.valueOf(tcmUri.getItemId());
            }
            catch (ParseException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return null;
            }
        } else {
            key = "title".equals(this.schemaKey) ? schema.getTitle() : schema.getId();
        }
        return this.getSchemaToUrlMappings().get(key);
    }

    public Map<String, String> getSchemaToUrlMappings() {
        if (this.schemaToUrlMappings == null) {
            this.schemaToUrlMappings = new HashMap<String, String>();
        }
        return this.schemaToUrlMappings;
    }

    public void setSchemaToUrlMappings(Map<String, String> schemaToUrlMappings) {
        this.schemaToUrlMappings = schemaToUrlMappings;
    }

    public String getSchemaKey() {
        return this.schemaKey;
    }

    public void setSchemaKey(String schemaKey) {
        this.schemaKey = schemaKey;
    }

    public boolean getEncodeUrl() {
        return this.encodeUrl;
    }

    public void setEncodeUrl(boolean encodeUrl) {
        this.encodeUrl = encodeUrl;
    }

    public String getContextPath() {
        if (this.contextPath == null) {
            this.contextPath = "";
        }
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public LinkProvider getLinkProvider() {
        return this.linkProvider;
    }

    public void setLinkProvider(LinkProvider linkProvider) {
        this.linkProvider = linkProvider;
    }

    public PayloadCacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(PayloadCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }
}

