/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.processors.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.dd4t.contentmodel.Component;
import org.dd4t.contentmodel.ComponentPresentation;
import org.dd4t.contentmodel.Field;
import org.dd4t.contentmodel.FieldSet;
import org.dd4t.contentmodel.Item;
import org.dd4t.contentmodel.Page;
import org.dd4t.contentmodel.impl.EmbeddedField;
import org.dd4t.contentmodel.impl.XhtmlField;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.ProcessorException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.core.processors.Processor;
import org.dd4t.core.processors.impl.BaseProcessor;
import org.dd4t.core.request.RequestContext;
import org.dd4t.core.util.RichTextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RichTextResolver
extends BaseProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(RichTextResolver.class);

    public void execute(Item item, RequestContext context) throws ProcessorException {
        if (item instanceof Page) {
            try {
                this.resolvePage((Page)item);
            }
            catch (TransformerException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new ProcessorException((Throwable)e);
            }
        } else if (item instanceof ComponentPresentation) {
            try {
                this.resolveComponent(((ComponentPresentation)item).getComponent());
            }
            catch (TransformerException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new ProcessorException((Throwable)e);
            }
        } else if (item instanceof Component) {
            try {
                this.resolveComponent((Component)item);
            }
            catch (TransformerException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new ProcessorException((Throwable)e);
            }
        } else {
            LOG.debug("RichTextResolverFilter. Item is not a GenericPage or GenericComponent so no component to resolve");
        }
        LOG.debug("RichTextResolverFilter finished");
    }

    protected void resolvePage(Page page) throws TransformerException {
        List cpList = page.getComponentPresentations();
        if (cpList != null) {
            for (ComponentPresentation cp : cpList) {
                this.resolveComponent(cp.getComponent());
            }
        }
        this.resolveMap(page.getMetadata());
    }

    protected void resolveComponent(Component component) throws TransformerException {
        if (component != null) {
            this.resolveMap(component.getContent());
            this.resolveMap(component.getMetadata());
        }
    }

    protected void resolveMap(Map<String, Field> fieldMap) throws TransformerException {
        if (fieldMap == null || fieldMap.isEmpty()) {
            return;
        }
        Collection<Field> values = fieldMap.values();
        for (Field field : values) {
            if (field instanceof XhtmlField) {
                this.resolveXhtmlField((XhtmlField)field);
            }
            if (!(field instanceof EmbeddedField)) continue;
            EmbeddedField ef = (EmbeddedField)field;
            for (FieldSet fs : ef.getEmbeddedValues()) {
                this.resolveMap(fs.getContent());
            }
        }
    }

    protected void resolveXhtmlField(XhtmlField xhtmlField) throws TransformerException {
        try {
            RichTextUtils.resolveXhtmlField(xhtmlField, false, null, null);
        }
        catch (ItemNotFoundException | SerializationException e) {
            throw new TransformerException(e);
        }
    }
}

