/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.processors.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.transform.TransformerException;
import org.dd4t.contentmodel.Component;
import org.dd4t.contentmodel.ComponentPresentation;
import org.dd4t.contentmodel.Field;
import org.dd4t.contentmodel.FieldSet;
import org.dd4t.contentmodel.Item;
import org.dd4t.contentmodel.Page;
import org.dd4t.contentmodel.impl.ComponentLinkField;
import org.dd4t.contentmodel.impl.EmbeddedField;
import org.dd4t.contentmodel.impl.XhtmlField;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.ProcessorException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.core.processors.LinkResolverProcessor;
import org.dd4t.core.processors.impl.BaseProcessor;
import org.dd4t.core.request.RequestContext;
import org.dd4t.core.resolvers.LinkResolver;
import org.dd4t.core.util.RichTextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkingProcessor
extends BaseProcessor
implements LinkResolverProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LinkingProcessor.class);
    @Resource
    private LinkResolver linkResolver;
    private String contextPath;
    private Map<String, Object> params = new HashMap<String, Object>();

    public void execute(Item item, RequestContext context) throws ProcessorException {
        this.linkResolver.setContextPath(this.contextPath);
        if (item instanceof Page) {
            try {
                this.resolvePage((Page)item);
            }
            catch (TransformerException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new ProcessorException((Throwable)e);
            }
        } else if (item instanceof Component) {
            try {
                this.resolveComponent((Component)item);
            }
            catch (TransformerException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new ProcessorException((Throwable)e);
            }
        } else {
            LOG.debug("DefaultLinkResolverFilter. Item is not a GenericPage or GenericComponent so no component to resolve");
        }
    }

    protected void resolvePage(Page page) throws TransformerException {
        List cpList = page.getComponentPresentations();
        if (cpList != null) {
            for (ComponentPresentation cp : cpList) {
                this.resolveComponentOnPage(cp.getComponent());
            }
        }
        this.resolveMap(page.getMetadata());
    }

    protected void resolveComponentOnPage(Component component) throws TransformerException {
        if (component != null) {
            this.resolveMap(component.getContent());
            this.resolveMap(component.getMetadata());
        }
    }

    protected void resolveComponent(Component component) throws TransformerException {
        try {
            if (component != null) {
                this.resolveMap(component.getContent());
                this.resolveMap(component.getMetadata());
                this.linkResolver.resolve(component);
            }
        }
        catch (ItemNotFoundException | SerializationException e) {
            throw new TransformerException(e);
        }
    }

    protected void resolveMap(Map<String, Field> fieldMap) throws TransformerException {
        if (fieldMap != null && !fieldMap.isEmpty()) {
            Collection<Field> values = fieldMap.values();
            for (Field field : values) {
                if (field instanceof ComponentLinkField) {
                    this.resolveComponentLinkField((ComponentLinkField)field);
                    continue;
                }
                if (field instanceof EmbeddedField) {
                    this.resolveList(((EmbeddedField)field).getEmbeddedValues());
                    continue;
                }
                if (!(field instanceof XhtmlField)) continue;
                this.resolveXhtmlField((XhtmlField)field);
            }
        }
    }

    protected void resolveList(List<FieldSet> fslist) throws TransformerException {
        if (fslist != null && !fslist.isEmpty()) {
            for (FieldSet fs : fslist) {
                this.resolveMap(fs.getContent());
            }
        }
    }

    protected void resolveComponentLinkField(ComponentLinkField componentLinkField) throws TransformerException {
        List<Object> compList = componentLinkField.getValues();
        for (Object component : compList) {
            this.resolveComponent((Component)component);
        }
    }

    protected void resolveXhtmlField(XhtmlField xhtmlField) throws TransformerException {
        try {
            RichTextUtils.resolveXhtmlField(xhtmlField, true, this.linkResolver, this.getContextPath());
        }
        catch (ItemNotFoundException | SerializationException e) {
            throw new TransformerException(e);
        }
    }

    public LinkResolver getLinkResolver() {
        return this.linkResolver;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
        this.params = new HashMap<String, Object>();
        this.params.put("contextpath", contextPath);
    }
}

