/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.processors.impl;

import javax.annotation.Resource;
import org.dd4t.contentmodel.ComponentPresentation;
import org.dd4t.contentmodel.Item;
import org.dd4t.contentmodel.Page;
import org.dd4t.core.exceptions.FactoryException;
import org.dd4t.core.factories.ComponentPresentationFactory;
import org.dd4t.core.processors.Processor;
import org.dd4t.core.processors.impl.BaseProcessor;
import org.dd4t.core.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcpResolver
extends BaseProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(DcpResolver.class);
    @Resource
    protected ComponentPresentationFactory componentPresentationFactory;

    public void execute(Item item, RequestContext context) {
        LOG.debug("Processing item: {} ", (Object)item);
        if (item instanceof Page) {
            Page page = (Page)item;
            LOG.debug("DCP Resolver detected {} component presentations.", (Object)page.getComponentPresentations().size());
            for (ComponentPresentation cp : page.getComponentPresentations()) {
                if (!cp.isDynamic()) continue;
                LOG.debug("Detected dynamic component presentation " + cp);
                try {
                    ComponentPresentation componentPresentation = this.componentPresentationFactory.getComponentPresentation(cp.getComponent().getId(), cp.getComponentTemplate().getId());
                    cp.setComponent(componentPresentation.getComponent());
                    cp.setViewModel(componentPresentation.getAllViewModels());
                }
                catch (FactoryException e) {
                    LOG.error("Unable to find dynamic component by id " + cp.getComponent().getId(), (Throwable)e);
                }
            }
        }
    }

    public ComponentPresentationFactory getComponentPresentationFactory() {
        return this.componentPresentationFactory;
    }

    public void setComponentPresentationFactory(ComponentPresentationFactory componentPresentationFactory) {
        this.componentPresentationFactory = componentPresentationFactory;
    }
}

