/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.factories.impl;

import java.io.IOException;
import java.text.ParseException;
import javax.annotation.Resource;
import org.dd4t.caching.CacheElement;
import org.dd4t.contentmodel.Keyword;
import org.dd4t.contentmodel.impl.KeywordImpl;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.core.factories.TaxonomyFactory;
import org.dd4t.core.factories.impl.BaseFactory;
import org.dd4t.core.serializers.Serializer;
import org.dd4t.core.util.TCMURI;
import org.dd4t.providers.PayloadCacheProvider;
import org.dd4t.providers.TaxonomyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxonomyFactoryImpl
extends BaseFactory
implements TaxonomyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TaxonomyFactoryImpl.class);
    private static final String NOT_FOUND_ERROR_MESSAGE = "Failed to read taxonomy {} from provider";
    @Resource
    protected TaxonomyProvider taxonomyProvider;
    @Resource
    protected Serializer serializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Keyword getTaxonomy(String taxonomyURI) throws IOException {
        Keyword taxonomy;
        LOG.debug("Enter getTaxonomy with uri: {}", (Object)taxonomyURI);
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(taxonomyURI);
        if (cacheElement.isExpired()) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    try {
                        String taxonomySource = this.taxonomyProvider.getTaxonomyByURI(taxonomyURI, true);
                        if (taxonomySource == null || taxonomySource.length() == 0) {
                            cacheElement.setPayload(null);
                            this.cacheProvider.storeInItemCache(taxonomyURI, cacheElement);
                            cacheElement.setExpired(true);
                            throw new ItemNotFoundException(String.format("Taxonomy with uri: %s not found.", taxonomyURI));
                        }
                        taxonomy = this.deserialize(taxonomySource, KeywordImpl.class);
                        cacheElement.setPayload((Object)taxonomy);
                        TCMURI tcmUri = new TCMURI(taxonomyURI);
                        this.cacheProvider.storeInItemCache(taxonomyURI, cacheElement, tcmUri.getPublicationId(), tcmUri.getItemId());
                        cacheElement.setExpired(false);
                        LOG.debug("Added taxonomy with uri: {} to cache", (Object)taxonomyURI);
                    }
                    catch (ParseException | ItemNotFoundException | SerializationException e) {
                        LOG.error(NOT_FOUND_ERROR_MESSAGE, (Object)taxonomyURI, (Object)e);
                        throw new IOException(e);
                    }
                } else {
                    LOG.debug("Return taxonomy with uri: {} from cache", (Object)taxonomyURI);
                    taxonomy = (Keyword)cacheElement.getPayload();
                }
            }
        } else {
            LOG.debug("Return taxonomy with uri: {} from cache", (Object)taxonomyURI);
            taxonomy = (Keyword)cacheElement.getPayload();
        }
        if (taxonomy == null) {
            throw new IOException("Failed to read taxonomy " + taxonomyURI + " from provider");
        }
        return taxonomy;
    }

    private Keyword deserialize(String taxonomySource, Class<KeywordImpl> keywordClass) throws SerializationException {
        return (Keyword)this.serializer.deserialize(taxonomySource, keywordClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Keyword getTaxonomyFilterBySchema(String taxonomyURI, String schemaURI) throws IOException {
        Keyword taxonomy;
        LOG.debug("Enter getTaxonomyFilterBySchema with uri: {} and schema: {}", (Object)taxonomyURI, (Object)schemaURI);
        String key = taxonomyURI + schemaURI;
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(key);
        if (cacheElement.isExpired()) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    try {
                        String taxonomySource = this.taxonomyProvider.getTaxonomyFilterBySchema(taxonomyURI, schemaURI);
                        if (taxonomySource == null || taxonomySource.length() == 0) {
                            cacheElement.setPayload(null);
                            this.cacheProvider.storeInItemCache(taxonomyURI, cacheElement);
                            cacheElement.setExpired(true);
                            throw new ItemNotFoundException("Taxonomy with uri: " + taxonomyURI + " not found.");
                        }
                        taxonomy = this.deserialize(taxonomySource, KeywordImpl.class);
                        cacheElement.setPayload((Object)taxonomy);
                        TCMURI tcmUri = new TCMURI(taxonomyURI);
                        this.cacheProvider.storeInItemCache(key, cacheElement, tcmUri.getPublicationId(), tcmUri.getItemId());
                        cacheElement.setExpired(false);
                        LOG.debug("Added taxonomy with uri: {} and schema: {} to cache", (Object)taxonomyURI, (Object)schemaURI);
                    }
                    catch (ItemNotFoundException e) {
                        cacheElement.setPayload(null);
                        this.cacheProvider.storeInItemCache(taxonomyURI, cacheElement);
                        cacheElement.setExpired(true);
                        LOG.error(e.getLocalizedMessage(), (Throwable)e);
                        throw new IOException("Taxonomy with uri: " + taxonomyURI + " not found.");
                    }
                    catch (ParseException | SerializationException e) {
                        LOG.error(NOT_FOUND_ERROR_MESSAGE, (Object)taxonomyURI, (Object)e);
                        throw new IOException(e);
                    }
                } else {
                    LOG.debug("Return taxonomy with uri: {} and schema: {} from cache", (Object)taxonomyURI, (Object)schemaURI);
                    taxonomy = (Keyword)cacheElement.getPayload();
                }
            }
        } else {
            LOG.debug("Return taxonomy with uri: {} and schema: {} from cache", (Object)taxonomyURI, (Object)schemaURI);
            taxonomy = (Keyword)cacheElement.getPayload();
        }
        if (taxonomy == null) {
            throw new IOException(NOT_FOUND_ERROR_MESSAGE);
        }
        return taxonomy;
    }

    @Override
    public void setCacheProvider(PayloadCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void setTaxonomyProvider(TaxonomyProvider taxonomyProvider) {
        this.taxonomyProvider = taxonomyProvider;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }
}

