/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.factories.impl;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.caching.CacheElement;
import org.dd4t.contentmodel.Item;
import org.dd4t.contentmodel.Page;
import org.dd4t.contentmodel.impl.PageImpl;
import org.dd4t.core.databind.DataBinder;
import org.dd4t.core.exceptions.FactoryException;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.ProcessorException;
import org.dd4t.core.exceptions.SerializationException;
import org.dd4t.core.factories.PageFactory;
import org.dd4t.core.factories.impl.BaseFactory;
import org.dd4t.core.processors.RunPhase;
import org.dd4t.core.request.RequestContext;
import org.dd4t.core.util.TCMURI;
import org.dd4t.providers.PageProvider;
import org.dd4t.providers.PageProviderResultItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageFactoryImpl
extends BaseFactory
implements PageFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PageFactoryImpl.class);
    @Resource
    protected PageProvider pageProvider;
    @Resource
    protected List<DataBinder> dataBinders;

    public Page getPage(String uri) throws FactoryException {
        return this.getPage(uri, null, PageImpl.class);
    }

    public Page findPageByUrl(String url, int publicationId) throws FactoryException {
        return this.findPageByUrl(url, publicationId, null, PageImpl.class);
    }

    private void executePostCacheProcessors(Page page, RequestContext context) {
        if (page != null) {
            LOG.debug("Running Post caching Processors");
            try {
                this.executeProcessors((Item)page, RunPhase.AFTER_CACHING, context);
            }
            catch (ProcessorException e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findSourcePageByUrl(String url, int publicationId) throws FactoryException {
        String page;
        LOG.debug("Enter findXMLPageByUrl with url: {} and publicationId: {}", (Object)url, (Object)publicationId);
        String cacheKey = "PSE-" + publicationId + "-" + url.toLowerCase();
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(cacheKey);
        if (cacheElement.isExpired()) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    page = this.pageProvider.getPageContentByURL(url, publicationId);
                    if (page == null || page.length() == 0) {
                        cacheElement.setPayload(null);
                        this.cacheProvider.storeInItemCache(cacheKey, cacheElement);
                        cacheElement.setExpired(true);
                        throw new ItemNotFoundException("XML Page with url: " + url + " not found.");
                    }
                    cacheElement.setPayload((Object)page);
                    this.cacheProvider.storeInItemCache(cacheKey, cacheElement);
                    cacheElement.setExpired(false);
                    LOG.debug("Added XML page with uri: {} and publicationId: {} to cache", (Object)url, (Object)publicationId);
                } else {
                    LOG.debug("Return a XML page with url: {} and publicationId: {} from cache", (Object)url, (Object)publicationId);
                    page = (String)cacheElement.getPayload();
                }
            }
        } else {
            LOG.debug("Return XML page with url: {} and publicationId: {} from cache", (Object)url, (Object)publicationId);
            page = (String)cacheElement.getPayload();
        }
        if (page == null) {
            throw new ItemNotFoundException("Page with url: " + url + " not found.");
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findSourcePageByTcmId(String tcmId) throws FactoryException {
        String pageSource;
        LOG.debug("Enter findSourcePageByTcmId with uri: {}", (Object)tcmId);
        String cacheKey = "PSE-" + tcmId;
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(cacheKey);
        if (cacheElement.isExpired()) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    try {
                        pageSource = this.pageProvider.getPageContentById(tcmId);
                    }
                    catch (ParseException e) {
                        LOG.error(e.getLocalizedMessage(), (Throwable)e);
                        throw new SerializationException((Throwable)e);
                    }
                    if (StringUtils.isEmpty((CharSequence)pageSource)) {
                        cacheElement.setPayload(null);
                        this.cacheProvider.storeInItemCache(cacheKey, cacheElement);
                        cacheElement.setExpired(true);
                        throw new ItemNotFoundException("Unable to find page by id " + tcmId);
                    }
                    cacheElement.setPayload((Object)pageSource);
                    this.cacheProvider.storeInItemCache(cacheKey, cacheElement);
                    cacheElement.setExpired(false);
                } else {
                    LOG.debug("Return a page with uri: {} from cache", (Object)tcmId);
                    pageSource = (String)cacheElement.getPayload();
                }
            }
        }
        LOG.debug("Return page with uri: {} from cache", (Object)tcmId);
        pageSource = (String)cacheElement.getPayload();
        return pageSource;
    }

    public TCMURI findPageIdByUrl(String url, int publicationId) throws FactoryException {
        return this.pageProvider.getPageIdForUrl(url, publicationId);
    }

    protected DataBinder selectDataBinder(String source) throws FactoryException {
        if (this.dataBinders == null || this.dataBinders.size() == 0) {
            return null;
        }
        if (this.dataBinders.size() == 1) {
            return this.dataBinders.get(0);
        }
        for (DataBinder binder : this.dataBinders) {
            if (!binder.canDeserialize(source)) continue;
            return binder;
        }
        return null;
    }

    public Boolean isPagePublished(String url, int publicationId) {
        LOG.debug("Enter isPagePublished with url: {} and publicationId: {}", (Object)url, (Object)publicationId);
        try {
            return this.pageProvider.checkPageExists(url, publicationId);
        }
        catch (ItemNotFoundException | SerializationException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return false;
        }
    }

    public <T extends Page> T getPage(String uri, Class<T> pageModel) throws FactoryException {
        if (!pageModel.getClass().isInstance(Page.class)) {
            throw new SerializationException("Given model class does not implement the Page interface");
        }
        return this.getPage(uri, null, pageModel);
    }

    public Page getPage(String uri, RequestContext context) throws FactoryException {
        return this.getPage(uri, context, PageImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Page> T getPage(String uri, RequestContext context, Class<T> pageModel) throws FactoryException {
        Object page;
        if (!pageModel.getClass().isInstance(Page.class)) {
            throw new SerializationException("Given model class does not implement the Page interface");
        }
        LOG.debug("Enter getPage with uri: {}", (Object)uri);
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(uri);
        if (cacheElement.isExpired()) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    String pageSource;
                    PageProviderResultItem resultItem;
                    TCMURI tcmUri;
                    try {
                        tcmUri = new TCMURI(uri);
                        resultItem = this.pageProvider.getPageById(tcmUri.getItemId(), tcmUri.getPublicationId());
                        pageSource = (String)resultItem.getSourceContent();
                    }
                    catch (IOException | ParseException e) {
                        LOG.error(e.getLocalizedMessage(), (Throwable)e);
                        throw new SerializationException((Throwable)e);
                    }
                    if (StringUtils.isEmpty((CharSequence)pageSource)) {
                        cacheElement.setPayload(null);
                        cacheElement.setNull(true);
                        this.cacheProvider.storeInItemCache(uri, cacheElement);
                        throw new ItemNotFoundException("Unable to find page by id " + uri);
                    }
                    page = this.producePage((PageProviderResultItem<String>)resultItem, context, PageImpl.class);
                    cacheElement.setPayload(page);
                    this.cacheProvider.storeInItemCache(uri, cacheElement, tcmUri.getPublicationId(), tcmUri.getItemId());
                    cacheElement.setExpired(false);
                    LOG.debug("Added page with uri: {} to cache", (Object)uri);
                } else {
                    LOG.debug("Return a page with uri: {} from cache", (Object)uri);
                    page = (Page)cacheElement.getPayload();
                }
            }
        }
        LOG.debug("Return page with uri: {} from cache", (Object)uri);
        page = (Page)cacheElement.getPayload();
        if (page == null) {
            throw new ItemNotFoundException("Found nullreference for page in cache. Please try again later.");
        }
        this.executePostCacheProcessors((Page)page, context);
        return (T)page;
    }

    public Page findPageByUrl(String url, int publicationId, RequestContext context) throws FactoryException {
        return this.findPageByUrl(url, publicationId, context, PageImpl.class);
    }

    public <T extends Page> T findPageByUrl(String url, int publicationId, Class<T> pageModel) throws FactoryException {
        return this.findPageByUrl(url, publicationId, null, pageModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Page> T findPageByUrl(String url, int publicationId, RequestContext context, Class<T> pageModel) throws FactoryException {
        Object page;
        LOG.debug("Enter findPageByUrl with url: {} and publicationId: {}", (Object)url, (Object)publicationId);
        String cacheKey = publicationId + "-" + url.toLowerCase();
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(cacheKey);
        if (cacheElement.isExpired() || cacheElement.getPayload() == null) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired() || cacheElement.getPayload() == null) {
                    PageProviderResultItem resultItem = this.pageProvider.getPageByURL(url, publicationId);
                    String pageSource = (String)resultItem.getSourceContent();
                    if (StringUtils.isEmpty((CharSequence)pageSource)) {
                        cacheElement.setPayload(null);
                        this.cacheProvider.storeInItemCache(cacheKey, cacheElement);
                        cacheElement.setExpired(true);
                        throw new ItemNotFoundException("Page with url: " + url + " not found.");
                    }
                    page = this.producePage((PageProviderResultItem<String>)resultItem, context, PageImpl.class);
                    cacheElement.setPayload(page);
                    this.cacheProvider.storeInItemCache(cacheKey, cacheElement, resultItem.getPublicationId(), resultItem.getItemId());
                    cacheElement.setExpired(false);
                    LOG.debug("Added page with uri: {} and publicationId: {} to cache", (Object)url, (Object)publicationId);
                } else {
                    LOG.debug("Return a page with url: {} and publicationId: {} from cache", (Object)url, (Object)publicationId);
                    page = (Page)cacheElement.getPayload();
                }
            }
        } else {
            LOG.debug("Return page with url: {} and publicationId: {} from cache", (Object)url, (Object)publicationId);
            page = (Page)cacheElement.getPayload();
        }
        this.executePostCacheProcessors((Page)page, context);
        return (T)page;
    }

    private <T extends Page> T producePage(PageProviderResultItem<String> resultItem, RequestContext context, Class<T> pageClass) throws FactoryException {
        String pageSource = (String)resultItem.getSourceContent();
        T page = this.deserialize(pageSource, pageClass);
        page.setLastPublishedDate(resultItem.getLastPublishDate());
        page.setRevisionDate(resultItem.getRevisionDate());
        page.setUrl(resultItem.getUrl());
        LOG.debug("Running pre caching processors");
        this.executeProcessors((Item)page, RunPhase.BEFORE_CACHING, context);
        return page;
    }

    public <T extends Page> T deserialize(String source, Class<? extends T> clazz) throws FactoryException {
        DataBinder binder = this.selectDataBinder(source);
        if (binder == null) {
            throw new SerializationException("Unable to select databinder.");
        }
        return (T)binder.buildPage(source, clazz);
    }

    public void setPageProvider(PageProvider provider) {
        this.pageProvider = provider;
    }

    public List<DataBinder> getDataBinders() {
        return this.dataBinders;
    }

    public void setDataBinders(List<DataBinder> dataBinder) {
        this.dataBinders = dataBinder;
    }
}

