/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.factories.impl;

import java.text.ParseException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.dd4t.caching.CacheElement;
import org.dd4t.contentmodel.ComponentPresentation;
import org.dd4t.contentmodel.Item;
import org.dd4t.core.databind.DataBinder;
import org.dd4t.core.exceptions.FactoryException;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.exceptions.ProcessorException;
import org.dd4t.core.factories.ComponentPresentationFactory;
import org.dd4t.core.factories.impl.BaseFactory;
import org.dd4t.core.processors.RunPhase;
import org.dd4t.core.request.RequestContext;
import org.dd4t.core.util.TCMURI;
import org.dd4t.providers.ComponentPresentationProvider;
import org.dd4t.providers.ComponentPresentationResultItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentPresentationFactoryImpl
extends BaseFactory
implements ComponentPresentationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentPresentationFactoryImpl.class);
    @Resource
    protected ComponentPresentationProvider componentPresentationProvider;
    @Resource
    protected List<DataBinder> dataBinders;

    protected DataBinder selectDataBinder(String source) throws FactoryException {
        if (this.dataBinders == null || this.dataBinders.size() == 0) {
            return null;
        }
        if (this.dataBinders.size() == 1) {
            return this.dataBinders.get(0);
        }
        for (DataBinder binder : this.dataBinders) {
            if (!binder.canDeserialize(source)) continue;
            return binder;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentPresentation getComponentPresentation(String componentURI, String templateURI, RequestContext context) throws FactoryException {
        ComponentPresentation componentPresentation;
        int componentId;
        TCMURI componentTcmUri;
        LOG.debug("Enter getComponentPresentation with componentURI: {} and templateURI: {}", (Object)componentURI, (Object)templateURI);
        int templateId = 0;
        try {
            componentTcmUri = new TCMURI(componentURI);
        }
        catch (ParseException e) {
            throw new ItemNotFoundException((Throwable)e);
        }
        if (!StringUtils.isEmpty((CharSequence)templateURI)) {
            try {
                TCMURI templateTcmUri = new TCMURI(templateURI);
                templateId = templateTcmUri.getItemId();
            }
            catch (ParseException e) {
                throw new ItemNotFoundException("Provide a valid TCMURI");
            }
        }
        componentURI = componentTcmUri.toString();
        int publicationId = componentTcmUri.getPublicationId();
        String key = this.getKey(publicationId, componentId = componentTcmUri.getItemId(), templateId);
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(key);
        if (cacheElement.isExpired()) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    ComponentPresentationResultItem result = this.componentPresentationProvider.getDynamicComponentPresentationItem(componentId, templateId, publicationId);
                    String rawComponentPresentation = (String)result.getSourceContent();
                    if (rawComponentPresentation == null) {
                        cacheElement.setPayload(null);
                        cacheElement.setNull(true);
                        this.cacheProvider.storeInItemCache(key, cacheElement);
                        throw new ItemNotFoundException(String.format("Could not find DCP with componentURI: %s and templateURI: %s", componentURI, templateURI));
                    }
                    componentPresentation = this.selectDataBinder(rawComponentPresentation).buildComponentPresentation(rawComponentPresentation, ComponentPresentation.class);
                    componentPresentation.getComponentTemplate().setId(new TCMURI(result.getPublicationId(), result.getTemplateId(), 32).toString());
                    LOG.debug("Running pre caching processors");
                    this.executeProcessors((Item)componentPresentation.getComponent(), RunPhase.BEFORE_CACHING, context);
                    cacheElement.setPayload((Object)componentPresentation);
                    this.cacheProvider.storeInItemCache(key, cacheElement, publicationId, componentId);
                    cacheElement.setExpired(false);
                    LOG.debug("Added component with uri: {} and template: {} to cache", (Object)componentURI, (Object)templateURI);
                } else {
                    LOG.debug("Return component for componentURI: {} and templateURI: {} from cache", (Object)componentURI, (Object)templateURI);
                    componentPresentation = (ComponentPresentation)cacheElement.getPayload();
                }
            }
        } else {
            LOG.debug("Return component for componentURI: {} and templateURI: {} from cache", (Object)componentURI, (Object)templateURI);
            componentPresentation = (ComponentPresentation)cacheElement.getPayload();
        }
        if (componentPresentation != null) {
            LOG.debug("Running Post caching Processors");
            try {
                this.executeProcessors((Item)componentPresentation.getComponent(), RunPhase.AFTER_CACHING, context);
            }
            catch (ProcessorException e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            throw new ItemNotFoundException("Found nullreference in DCP cache. Try again later.");
        }
        LOG.debug("Exit getComponentPresentation");
        return componentPresentation;
    }

    private String getKey(int publicationId, int componentId, int templateId) {
        return String.format("Component-%d-%d-%d", publicationId, componentId, templateId);
    }

    public ComponentPresentationProvider getComponentPresentationProvider() {
        return this.componentPresentationProvider;
    }

    public void setComponentPresentationProvider(ComponentPresentationProvider componentPresentationProvider) {
        this.componentPresentationProvider = componentPresentationProvider;
    }

    public List<DataBinder> getDataBinders() {
        return this.dataBinders;
    }

    public void setDataBinders(List<DataBinder> dataBinder) {
        this.dataBinders = dataBinder;
    }

    public ComponentPresentation getComponentPresentation(String componentURI) throws FactoryException {
        return this.getComponentPresentation(componentURI, null, null);
    }

    public ComponentPresentation getComponentPresentation(String componentURI, String viewOrTemplateURI) throws FactoryException {
        return this.getComponentPresentation(componentURI, viewOrTemplateURI, null);
    }

    public ComponentPresentation getComponentPresentation(String componentURI, RequestContext context) throws FactoryException {
        return this.getComponentPresentation(componentURI, null, context);
    }
}

