/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.factories.impl;

import java.text.ParseException;
import org.dd4t.caching.CacheElement;
import org.dd4t.contentmodel.Binary;
import org.dd4t.core.exceptions.FactoryException;
import org.dd4t.core.exceptions.ItemNotFoundException;
import org.dd4t.core.factories.BinaryFactory;
import org.dd4t.core.factories.impl.BaseFactory;
import org.dd4t.core.util.TCMURI;
import org.dd4t.providers.BinaryProvider;
import org.dd4t.providers.PayloadCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryFactoryImpl
extends BaseFactory
implements BinaryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryFactoryImpl.class);
    private PayloadCacheProvider cacheProvider;
    private BinaryProvider binaryProvider;

    protected BinaryFactoryImpl() {
        LOG.debug("Create new instance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binary getBinaryByURI(String tcmUri) throws FactoryException {
        Binary binary;
        LOG.debug("Enter getBinaryByURI with uri: {}", (Object)tcmUri);
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(tcmUri);
        if (cacheElement.isExpired()) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    try {
                        binary = this.binaryProvider.getBinaryByURI(tcmUri);
                        cacheElement.setPayload((Object)binary);
                        TCMURI binaryURI = new TCMURI(tcmUri);
                        this.cacheProvider.storeInItemCache(tcmUri, cacheElement, binaryURI.getPublicationId(), binaryURI.getItemId());
                        cacheElement.setExpired(false);
                        LOG.debug("Added binary with uri: {} to cache", (Object)tcmUri);
                    }
                    catch (ParseException e) {
                        cacheElement.setPayload(null);
                        this.cacheProvider.storeInItemCache(tcmUri, cacheElement);
                        cacheElement.setExpired(true);
                        throw new ItemNotFoundException((Throwable)e);
                    }
                } else {
                    LOG.debug("Return a binary with uri: {} from cache", (Object)tcmUri);
                    binary = (Binary)cacheElement.getPayload();
                }
            }
        } else {
            LOG.debug("Return binary with uri: {} from cache", (Object)tcmUri);
            binary = (Binary)cacheElement.getPayload();
            if (binary == null) {
                throw new ItemNotFoundException("Found nullreference for binary in cache.");
            }
        }
        return binary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binary getBinaryByURL(String url, int publicationId) throws FactoryException {
        Binary binary;
        LOG.debug("Enter getBinaryByURL with url: {} and publicationId: {}", (Object)url, (Object)publicationId);
        String key = this.getCacheKey(url, publicationId);
        CacheElement cacheElement = this.cacheProvider.loadPayloadFromLocalCache(key);
        if (cacheElement.isExpired()) {
            CacheElement cacheElement2 = cacheElement;
            synchronized (cacheElement2) {
                if (cacheElement.isExpired()) {
                    try {
                        binary = this.binaryProvider.getBinaryByURL(url, publicationId);
                        cacheElement.setPayload((Object)binary);
                        TCMURI tcmUri = new TCMURI(binary.getId());
                        this.cacheProvider.storeInItemCache(key, cacheElement, tcmUri.getPublicationId(), tcmUri.getItemId());
                        cacheElement.setExpired(false);
                        LOG.debug("Added binary with url: {} to cache", (Object)url);
                    }
                    catch (ParseException e) {
                        throw new ItemNotFoundException((Throwable)e);
                    }
                } else {
                    LOG.debug("Return a binary with url: {} from cache", (Object)url);
                    binary = (Binary)cacheElement.getPayload();
                }
            }
        } else {
            LOG.debug("Return binary with url: {} from cache", (Object)url);
            binary = (Binary)cacheElement.getPayload();
        }
        return binary;
    }

    @Override
    public void setCacheProvider(PayloadCacheProvider cacheAgent) {
        this.cacheProvider = cacheAgent;
    }

    public void setBinaryProvider(BinaryProvider binaryProvider) {
        this.binaryProvider = binaryProvider;
    }

    private String getCacheKey(String url, int publicationId) {
        return String.format("B-%s-%d", url, publicationId);
    }
}

