/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.factories.impl;

import java.util.ArrayList;
import java.util.List;
import org.dd4t.contentmodel.Item;
import org.dd4t.core.exceptions.ProcessorException;
import org.dd4t.core.processors.Processor;
import org.dd4t.core.processors.RunPhase;
import org.dd4t.core.request.RequestContext;
import org.dd4t.providers.PayloadCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BaseFactory.class);
    protected PayloadCacheProvider cacheProvider;
    protected List<Processor> processors;

    public List<Processor> getProcessors() {
        if (this.processors == null) {
            this.processors = new ArrayList<Processor>();
        }
        return this.processors;
    }

    public void setProcessors(List<Processor> processors) {
        this.processors = new ArrayList<Processor>();
        for (Processor processor : processors) {
            this.processors.add(processor);
        }
    }

    public void executeProcessors(Item item, RunPhase runPhase, RequestContext context) throws ProcessorException {
        if (item != null) {
            for (Processor processor : this.getProcessors()) {
                if (runPhase != processor.getRunPhase() && processor.getRunPhase() != RunPhase.BOTH) continue;
                this.execute(processor, item, context);
            }
        }
    }

    private void execute(Processor processor, Item item, RequestContext context) throws ProcessorException {
        processor.execute(item, context);
    }

    public void setCacheProvider(PayloadCacheProvider cacheAgent) {
        this.cacheProvider = cacheAgent;
    }
}

