/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.contentmodel.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dd4t.contentmodel.Category;
import org.dd4t.contentmodel.Field;
import org.dd4t.contentmodel.OrganizationalItem;
import org.dd4t.contentmodel.Publication;
import org.dd4t.contentmodel.RepositoryLocalItem;
import org.dd4t.contentmodel.Schema;
import org.dd4t.contentmodel.impl.BaseField;
import org.dd4t.contentmodel.impl.BaseItem;
import org.dd4t.contentmodel.impl.CategoryImpl;
import org.dd4t.contentmodel.impl.OrganizationalItemImpl;
import org.dd4t.contentmodel.impl.PublicationImpl;
import org.dd4t.contentmodel.impl.SchemaImpl;
import org.dd4t.core.util.DateUtils;
import org.joda.time.DateTime;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementMap;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class BaseRepositoryLocalItem
extends BaseItem
implements RepositoryLocalItem {
    @Element(name="revisionDate", required=false)
    @JsonProperty(value="RevisionDate")
    protected String revisionDateAsString;
    @Element(name="publication", required=false)
    @JsonProperty(value="Publication")
    @JsonDeserialize(as=PublicationImpl.class)
    protected Publication publication;
    @Element(name="owningPublication", required=false)
    @JsonProperty(value="OwningPublication")
    @JsonDeserialize(as=PublicationImpl.class)
    protected Publication owningPublication;
    @Element(name="folder", required=false)
    @JsonProperty(value="Folder")
    @JsonDeserialize(as=OrganizationalItemImpl.class)
    protected OrganizationalItem organizationalItem;
    @Element(name="lastPublishedDate", required=false)
    @JsonProperty(value="LastPublishedDate")
    protected String lastPublishedDateAsString;
    @Element(name="version", required=false)
    @JsonProperty(value="Version")
    protected int version;
    @ElementMap(name="metadata", keyType=String.class, valueType=Field.class, entry="item", required=false)
    @JsonProperty(value="MetadataFields")
    @JsonDeserialize(contentAs=BaseField.class)
    protected Map<String, Field> metadata;
    @JsonProperty(value="Categories")
    @JsonDeserialize(contentAs=CategoryImpl.class)
    protected List<Category> categories;
    @Element(name="schema", required=false)
    @JsonProperty(value="Schema")
    @JsonDeserialize(as=SchemaImpl.class)
    private Schema schema;

    public OrganizationalItem getOrganizationalItem() {
        return this.organizationalItem;
    }

    public void setOrganizationalItem(OrganizationalItem organizationalItem) {
        this.organizationalItem = organizationalItem;
    }

    public Publication getOwningPublication() {
        return this.owningPublication;
    }

    public void setOwningPublication(Publication publication) {
        this.owningPublication = publication;
    }

    public Publication getPublication() {
        return this.publication;
    }

    public void setPublication(Publication publication) {
        this.publication = publication;
    }

    public DateTime getRevisionDate() {
        if (this.revisionDateAsString == null || this.revisionDateAsString.isEmpty()) {
            return new DateTime();
        }
        return DateUtils.convertStringWithOffsetToDate((String)this.revisionDateAsString);
    }

    public void setRevisionDate(DateTime date) {
        this.revisionDateAsString = DateUtils.convertDateToString((DateTime)date);
    }

    public DateTime getLastPublishedDate() {
        if (this.lastPublishedDateAsString == null || this.lastPublishedDateAsString.isEmpty()) {
            return new DateTime();
        }
        return DateUtils.convertStringToDate((String)this.lastPublishedDateAsString);
    }

    public void setLastPublishedDate(DateTime date) {
        this.lastPublishedDateAsString = DateUtils.convertDateToString((DateTime)date);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Map<String, Field> getMetadata() {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Field>();
        }
        return this.metadata;
    }

    public void setMetadata(Map<String, Field> metadata) {
        this.metadata = metadata;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }
}

