/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.contentmodel;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FieldType {
    TEXT(0),
    MULTILINETEXT(1),
    XHTML(2),
    KEYWORD(3),
    EMBEDDED(4),
    MULTIMEDIALINK(5),
    COMPONENTLINK(6),
    EXTERNALLINK(7),
    NUMBER(8),
    DATE(9),
    UNKNOWN(-1);

    private static final Logger LOG;
    private final int value;

    private FieldType(int value) {
        this.value = value;
    }

    public static FieldType findByValue(int value) {
        for (FieldType fieldType : FieldType.values()) {
            if (fieldType.getValue() != value) continue;
            return fieldType;
        }
        return UNKNOWN;
    }

    public static FieldType findByName(String name) {
        try {
            return FieldType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            LOG.error(iae.getLocalizedMessage(), (Throwable)iae);
            try {
                int value = Integer.parseInt(name);
                return FieldType.findByValue(value);
            }
            catch (NumberFormatException nfe) {
                LOG.error(nfe.getLocalizedMessage(), (Throwable)nfe);
                return UNKNOWN;
            }
        }
    }

    public int getValue() {
        return this.value;
    }

    static {
        LOG = LoggerFactory.getLogger(FieldType.class);
    }
}

