/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.core.util;

import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    private static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final String DATE_PATTERN_WITH_OFFSET = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final DateTimeFormatter DATE_TIME_FORMATTER_WITH_OFFSET = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    private DateUtils() {
    }

    public static String convertDateToString(DateTime date) {
        return DATE_TIME_FORMATTER.print((ReadableInstant)date);
    }

    public static String convertSqlTimestampToString(Timestamp timestamp) {
        return DateUtils.convertDateToString(new DateTime((Object)timestamp));
    }

    public static DateTime convertStringToDate(String date) {
        if (date.length() > 19) {
            return DATE_TIME_FORMATTER.parseDateTime(date);
        }
        return DATE_TIME_FORMATTER.parseDateTime(date + ".000");
    }

    public static DateTime convertStringWithOffsetToDate(String date) {
        if (date.endsWith("Z")) {
            return DATE_TIME_FORMATTER_WITH_OFFSET.parseDateTime(date);
        }
        return DateUtils.convertStringToDate(date);
    }
}

