/*
 * Decompiled with CFR 0.152.
 */
package org.dd4t.contentmodel;

import java.util.List;
import java.util.Map;
import org.dd4t.contentmodel.Category;
import org.dd4t.contentmodel.Field;
import org.dd4t.contentmodel.Multimedia;
import org.dd4t.contentmodel.RepositoryLocalItem;
import org.dd4t.contentmodel.Schema;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Component
extends RepositoryLocalItem {
    @Override
    public Schema getSchema();

    @Override
    public void setSchema(Schema var1);

    @Override
    public DateTime getLastPublishedDate();

    @Override
    public void setLastPublishedDate(DateTime var1);

    public Map<String, Field> getMetadata();

    public void setMetadata(Map<String, Field> var1);

    public Map<String, Field> getContent();

    public void setContent(Map<String, Field> var1);

    public ComponentType getComponentType();

    public void setComponentType(ComponentType var1);

    public Multimedia getMultimedia();

    public void setMultimedia(Multimedia var1);

    public List<Category> getCategories();

    public void setCategories(List<Category> var1);

    public int getVersion();

    public DateTime getRevisionDate();

    public void setRevisionDate(DateTime var1);

    public String getResolvedUrl();

    public void setResolvedUrl(String var1);

    public String getEclId();

    public static enum ComponentType {
        MULTIMEDIA(0),
        NORMAL(1),
        UNKNOWN(-1);

        private final int value;
        private static final Logger LOG;

        private ComponentType(int value) {
            this.value = value;
        }

        public static ComponentType findByValue(int value) {
            for (ComponentType componentType : ComponentType.values()) {
                if (componentType.getValue() != value) continue;
                return componentType;
            }
            return UNKNOWN;
        }

        public static ComponentType findByName(String name) {
            try {
                return ComponentType.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                LOG.error(iae.getLocalizedMessage(), (Throwable)iae);
                try {
                    int value = Integer.parseInt(name);
                    return ComponentType.findByValue(value);
                }
                catch (NumberFormatException nfe) {
                    LOG.error(nfe.getLocalizedMessage(), (Throwable)nfe);
                    return UNKNOWN;
                }
            }
        }

        public int getValue() {
            return this.value;
        }

        static {
            LOG = LoggerFactory.getLogger(ComponentType.class);
        }
    }
}

