/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.licensemanager;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.dbtools.licensemanager.LicenseManagerExtension;
import org.dbtools.licensemanager.LicenseReport;
import org.dbtools.licensemanager.LicenseReportDependency;
import org.dbtools.licensemanager.Pom;
import org.dbtools.licensemanager.PomLicense;
import org.dbtools.licensemanager.ReportTask;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0007J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\b\u0010\u0014\u001a\u00020\nH\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u0016H\u0002J\u001e\u0010\u001a\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001f\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0016H\u0002J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0#H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010(\u001a\u00020)H\u0002R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/dbtools/licensemanager/ReportTask;", "Lorg/gradle/api/DefaultTask;", "extension", "Lorg/dbtools/licensemanager/LicenseManagerExtension;", "(Lorg/dbtools/licensemanager/LicenseManagerExtension;)V", "getExtension", "()Lorg/dbtools/licensemanager/LicenseManagerExtension;", "json", "Lkotlinx/serialization/json/Json;", "createPomConfiguration", "", "execute", "filterExcludedArtifactIds", "", "Lorg/dbtools/licensemanager/Pom;", "allPoms", "filterExcludedGroups", "filterTransitiveDependencies", "configuration", "Lorg/gradle/api/artifacts/ResolvedConfiguration;", "findAllDependencies", "formatCsvName", "", "name", "formatUrl", "url", "generateLicenceReportCsv", "poms", "outputFile", "Ljava/io/File;", "generateLicenceReportHtml", "generateLicenceReportJson", "getOutputDir", "pathname", "getResolvedArtifactsFromResolvedDependencies", "", "Lorg/gradle/api/artifacts/ResolvedArtifact;", "resolvedDependencies", "Lorg/gradle/api/artifacts/ResolvedDependency;", "readPoms", "filterTransitive", "", "Companion", "license-manager"})
public class ReportTask
extends DefaultTask {
    private final Json json;
    @NotNull
    private final LicenseManagerExtension extension;
    private static final String POM_CONFIGURATION = "pom";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @TaskAction
    public final void execute() {
        List<Pom> poms = this.readPoms(false);
        if (this.extension.getCreateHtmlReport()) {
            this.generateLicenceReportHtml(poms, new File(this.getOutputDir(this.extension.getOutputDir()), this.extension.getOutputFilename() + ".html"));
        }
        if (this.extension.getCreateJsonReport()) {
            this.generateLicenceReportJson(poms, new File(this.getOutputDir(this.extension.getOutputDir()), this.extension.getOutputFilename() + ".json"));
        }
        if (this.extension.getCreateCsvReport()) {
            this.generateLicenceReportCsv(poms, new File(this.getOutputDir(this.extension.getOutputDir()), this.extension.getOutputFilename() + ".csv"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pom> readPoms(boolean filterTransitive) {
        void $this$mapTo$iv$iv;
        this.createPomConfiguration();
        this.findAllDependencies();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Configuration configuration = project.getConfigurations().getByName(POM_CONFIGURATION);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations\n \u2026ByName(POM_CONFIGURATION)");
        ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedConfiguration, (String)"project.configurations\n \u2026   .resolvedConfiguration");
        ResolvedConfiguration configuration2 = resolvedConfiguration;
        LenientConfiguration lenientConfiguration = configuration2.getLenientConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)lenientConfiguration, (String)"configuration.lenientConfiguration");
        Set set = lenientConfiguration.getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"configuration.lenientConfiguration.artifacts");
        Set artifacts = set;
        this.getLogger().info("Found Artifact Dependencies count: " + artifacts.size());
        XmlMapper xmlMapper = new XmlMapper();
        Iterable $this$map$iv = artifacts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File pomFile;
            void resolvedArtifact;
            ResolvedArtifact resolvedArtifact2 = (ResolvedArtifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v5 = resolvedArtifact;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"resolvedArtifact");
            Intrinsics.checkNotNullExpressionValue((Object)v5.getFile(), (String)"resolvedArtifact.file");
            Pom pom = (Pom)xmlMapper.readValue(pomFile, Pom.class);
            collection.add(pom);
        }
        List allPoms = (List)destination$iv$iv;
        if (filterTransitive) {
            allPoms = this.filterTransitiveDependencies(configuration2, allPoms);
        }
        $this$map$iv = this.extension.getExcludeGroups();
        $i$f$map = false;
        if (!$this$map$iv.isEmpty()) {
            allPoms = this.filterExcludedGroups(allPoms);
        }
        $this$map$iv = this.extension.getExcludeArtifactIds();
        $i$f$map = false;
        if (!$this$map$iv.isEmpty()) {
            allPoms = this.filterExcludedArtifactIds(allPoms);
        }
        Iterable $this$sortedBy$iv = allPoms;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        allPoms = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pom it = (Pom)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getArtifactId());
                it = (Pom)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getArtifactId();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        return allPoms;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pom> filterExcludedGroups(List<Pom> allPoms) {
        void $this$filterTo$iv$iv;
        List<String> filterGroups = this.extension.getExcludeGroups();
        Iterable $this$filter$iv = allPoms;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pom pom = (Pom)element$iv$iv;
            boolean bl = false;
            if (!(!CollectionsKt.contains((Iterable)filterGroups, (Object)pom.getGroupId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pom> filterExcludedArtifactIds(List<Pom> allPoms) {
        void $this$filterTo$iv$iv;
        List<String> filterArtifactIds = this.extension.getExcludeArtifactIds();
        Iterable $this$filter$iv = allPoms;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pom pom = (Pom)element$iv$iv;
            boolean bl = false;
            if (!(!CollectionsKt.contains((Iterable)filterArtifactIds, (Object)pom.getArtifactId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pom> filterTransitiveDependencies(ResolvedConfiguration configuration, List<Pom> allPoms) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Set set = configuration.getFirstLevelModuleDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"configuration\n          \u2026stLevelModuleDependencies");
        Set firstLevelModuleDependencies = set;
        Iterable $this$forEach$iv = firstLevelModuleDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolvedDependency dependency = (ResolvedDependency)element$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("   ");
            ResolvedModuleVersion resolvedModuleVersion = dependency.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedModuleVersion, (String)"dependency.module");
            String string = stringBuilder.append(resolvedModuleVersion.getId()).append("  / ").append(dependency.getModuleName()).toString();
            boolean bl2 = false;
            System.out.println((Object)string);
        }
        $this$forEach$iv = allPoms;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                Pom pom = (Pom)element$iv$iv;
                boolean bl3 = false;
                Iterable $this$any$iv = firstLevelModuleDependencies;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ResolvedDependency dependency = (ResolvedDependency)element$iv;
                        boolean bl4 = false;
                        if (!(Intrinsics.areEqual((Object)pom.getArtifactId(), (Object)dependency.getModuleName()) && Intrinsics.areEqual((Object)pom.getGroupId(), (Object)dependency.getModuleGroup()) && Intrinsics.areEqual((Object)pom.getVersion(), (Object)dependency.getModuleVersion()))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void createPomConfiguration() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ConfigurationContainer configurationContainer = project.getConfigurations();
        boolean bl = false;
        boolean bl2 = false;
        ConfigurationContainer $this$apply = configurationContainer;
        boolean bl3 = false;
        $this$apply.create(POM_CONFIGURATION);
        Iterable $this$forEach$iv = (Iterable)$this$apply;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Configuration configuration = (Configuration)element$iv;
            boolean bl4 = false;
            try {
                Configuration configuration2 = configuration;
                Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"configuration");
                configuration2.setCanBeResolved(true);
            }
            catch (Exception exception) {
            }
        }
    }

    private final void findAllDependencies() {
        Object v9;
        boolean bl;
        Object object;
        ConfigurationContainer configurations;
        LinkedHashSet<Object> configurationSet;
        block13: {
            Object v6;
            Configuration it;
            block12: {
                Object v3;
                block11: {
                    boolean bl2 = false;
                    configurationSet = new LinkedHashSet<Object>();
                    Project project = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    ConfigurationContainer configurationContainer = project.getConfigurations();
                    Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                    configurations = configurationContainer;
                    object = (Iterable)configurations;
                    bl = false;
                    Iterable iterable = object;
                    boolean bl3 = false;
                    for (Object object2 : iterable) {
                        it = (Configuration)object2;
                        boolean bl4 = false;
                        Configuration configuration = it;
                        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"it");
                        if (!Intrinsics.areEqual((Object)configuration.getName(), (Object)"compile")) continue;
                        v3 = object2;
                        break block11;
                    }
                    v3 = null;
                }
                Configuration configuration = v3;
                if (configuration != null) {
                    object = configuration;
                    bl = false;
                    boolean bl5 = false;
                    Iterable it2 = object;
                    boolean bl6 = false;
                    configurationSet.add(configurations.getByName("compile"));
                }
                object = (Iterable)configurations;
                bl = false;
                Iterable iterable = object;
                boolean it2 = false;
                for (Object object2 : iterable) {
                    it = (Configuration)object2;
                    boolean bl7 = false;
                    Configuration configuration2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"it");
                    if (!Intrinsics.areEqual((Object)configuration2.getName(), (Object)"api")) continue;
                    v6 = object2;
                    break block12;
                }
                v6 = null;
            }
            Configuration configuration = v6;
            if (configuration != null) {
                object = configuration;
                bl = false;
                boolean bl8 = false;
                Iterable it3 = object;
                boolean bl9 = false;
                configurationSet.add(configurations.getByName("api"));
            }
            object = (Iterable)configurations;
            bl = false;
            Iterable iterable = object;
            boolean it3 = false;
            for (Object object2 : iterable) {
                it = (Configuration)object2;
                boolean bl10 = false;
                Configuration configuration3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)configuration3, (String)"it");
                if (!Intrinsics.areEqual((Object)configuration3.getName(), (Object)"implementation")) continue;
                v9 = object2;
                break block13;
            }
            v9 = null;
        }
        Configuration configuration = v9;
        if (configuration != null) {
            object = configuration;
            bl = false;
            boolean bl11 = false;
            Iterable it = object;
            boolean bl12 = false;
            configurationSet.add(configurations.getByName("implementation"));
        }
        String string = this.extension.getVariantName();
        if (string != null) {
            Object v13;
            boolean it;
            Object object2;
            block14: {
                object = string;
                bl = false;
                boolean bl13 = false;
                Object variant = object;
                boolean bl14 = false;
                object2 = (Iterable)configurations;
                it = false;
                Object bl10 = object2;
                boolean bl15 = false;
                Iterator iterator = bl10.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    Configuration it4 = (Configuration)t;
                    boolean bl16 = false;
                    Configuration configuration4 = it4;
                    Intrinsics.checkNotNullExpressionValue((Object)configuration4, (String)"it");
                    if (!Intrinsics.areEqual((Object)configuration4.getName(), (Object)((String)variant + "RuntimeClasspath"))) continue;
                    v13 = t;
                    break block14;
                }
                v13 = null;
            }
            Configuration configuration5 = v13;
            if (configuration5 != null) {
                object2 = configuration5;
                it = false;
                boolean bl10 = false;
                Object it5 = object2;
                boolean bl17 = false;
                configurationSet.add(it5);
            }
        }
        Iterable $this$forEach$iv = configurationSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Set allDeps;
            Configuration configuration6 = (Configuration)element$iv;
            boolean bl18 = false;
            if (!configuration6.isCanBeResolved()) continue;
            ResolvedConfiguration resolvedConfiguration = configuration6.getResolvedConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedConfiguration, (String)"configuration.resolvedConfiguration");
            LenientConfiguration lenientConfiguration = resolvedConfiguration.getLenientConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)lenientConfiguration, (String)"configuration.resolvedCo\u2026tion.lenientConfiguration");
            Intrinsics.checkNotNullExpressionValue((Object)lenientConfiguration.getAllModuleDependencies(), (String)"configuration.resolvedCo\u2026ion.allModuleDependencies");
            Iterable $this$forEach$iv2 = this.getResolvedArtifactsFromResolvedDependencies(allDeps);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ModuleVersionIdentifier id;
                ResolvedArtifact artifact = (ResolvedArtifact)element$iv2;
                boolean bl19 = false;
                ResolvedModuleVersion resolvedModuleVersion = artifact.getModuleVersion();
                Intrinsics.checkNotNullExpressionValue((Object)resolvedModuleVersion, (String)"artifact.moduleVersion");
                Intrinsics.checkNotNullExpressionValue((Object)resolvedModuleVersion.getId(), (String)"artifact.moduleVersion.id");
                String gav = id.getGroup() + ':' + id.getName() + ':' + id.getVersion() + "@pom";
                Configuration configuration7 = configurations.getByName(POM_CONFIGURATION);
                Intrinsics.checkNotNullExpressionValue((Object)configuration7, (String)"configurations.getByName(POM_CONFIGURATION)");
                DependencySet dependencySet = configuration7.getDependencies();
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                dependencySet.add((Object)project.getDependencies().add(POM_CONFIGURATION, (Object)gav));
            }
        }
    }

    private final Set<ResolvedArtifact> getResolvedArtifactsFromResolvedDependencies(Set<? extends ResolvedDependency> resolvedDependencies) {
        boolean bl = false;
        HashSet resolvedArtifacts = new HashSet();
        Iterable $this$forEach$iv = resolvedDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolvedDependency resolvedDependency = (ResolvedDependency)element$iv;
            boolean bl2 = false;
            try {
                if (Intrinsics.areEqual((Object)resolvedDependency.getModuleVersion(), (Object)"unspecified")) {
                    Set set = resolvedDependency.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"resolvedDependency.children");
                    resolvedArtifacts.addAll(this.getResolvedArtifactsFromResolvedDependencies(set));
                    continue;
                }
                resolvedArtifacts.addAll(resolvedDependency.getAllModuleArtifacts());
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to process " + resolvedDependency + ".name", (Throwable)e);
            }
        }
        return resolvedArtifacts;
    }

    private final String formatUrl(String url) {
        String string = url;
        return string != null ? StringsKt.substringBeforeLast$default((String)string, (String)"#", null, (int)2, null) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String formatCsvName(String name) {
        String string;
        String string2 = name;
        if (string2 != null) {
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)",", (boolean)false, (int)2, null)) {
                string = '\"' + name + '\"';
                return string;
            }
        }
        string = name;
        return string;
    }

    private final void generateLicenceReportHtml(List<Pom> poms, File outputFile) {
        StringBuffer dependenciesHtml = new StringBuffer();
        Iterable $this$forEach$iv = poms;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pom pom = (Pom)element$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("\n                <p>\n                    <strong>");
            String string = pom.getName();
            if (string == null) {
                string = pom.getArtifactId();
            }
            List<PomLicense> list = pom.getLicenses();
            String dependencyHtml = StringsKt.trimIndent((String)stringBuilder.append(string).append("</strong><br/>\n                    \n                    ").append(pom.getUrl() != null ? "<strong>URL: </strong><a href='" + this.formatUrl(pom.getUrl()) + "'>" + this.formatUrl(pom.getUrl()) + "</a><br/>" : "").append("\n                     \n                    ").append(list != null ? CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"<br/>", null, null, (int)0, null, (Function1)((Function1)new Function1<PomLicense, CharSequence>(this, dependenciesHtml){
                final /* synthetic */ ReportTask this$0;
                final /* synthetic */ StringBuffer $dependenciesHtml$inlined;
                {
                    this.this$0 = reportTask;
                    this.$dependenciesHtml$inlined = stringBuffer;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull PomLicense license) {
                    Intrinsics.checkNotNullParameter((Object)license, (String)"license");
                    return "<strong>License: </strong>" + license.getName() + " - " + (license.getUrl() != null ? "<a href='" + ReportTask.access$formatUrl(this.this$0, license.getUrl()) + "'>" + ReportTask.access$formatUrl(this.this$0, license.getUrl()) : "") + "</a>";
                }
            }), (int)30, null) : null).append(" \n                </p>\n                <hr/>\n                \n            ").toString());
            dependenciesHtml.append(dependencyHtml);
        }
        String html = StringsKt.trimIndent((String)("\n                <html>\n                    <style>\n                        a { word-wrap: break-word;}\n                        strong { word-wrap: break-word;}\n                    </style>\n                    <body>\n                        " + dependenciesHtml + "\n                    </body>\n                </html>\n        "));
        if (outputFile.exists()) {
            outputFile.delete();
        }
        FilesKt.writeText$default((File)outputFile, (String)html, null, (int)2, null);
    }

    private final void generateLicenceReportJson(List<Pom> poms, File outputFile) {
        boolean bl = false;
        List dependencies = new ArrayList();
        Iterable $this$forEach$iv = poms;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pom pom = (Pom)element$iv;
            boolean bl2 = false;
            List<PomLicense> list = pom.getLicenses();
            PomLicense license = list != null ? (PomLicense)CollectionsKt.firstOrNull(list) : null;
            String formattedPomUrl = this.formatUrl(pom.getUrl());
            String string = pom.getName();
            if (string == null) {
                string = pom.getArtifactId();
            }
            PomLicense pomLicense = license;
            PomLicense pomLicense2 = license;
            dependencies.add(new LicenseReportDependency(string, formattedPomUrl, pom.getArtifactId(), pom.getVersion(), pomLicense != null ? pomLicense.getName() : null, pomLicense2 != null ? pomLicense2.getUrl() : null));
        }
        LicenseReport licenseReport = new LicenseReport(dependencies);
        String json2 = this.json.encodeToString((SerializationStrategy)LicenseReport.Companion.serializer(), (Object)licenseReport);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        FilesKt.writeText$default((File)outputFile, (String)json2, null, (int)2, null);
    }

    private final void generateLicenceReportCsv(List<Pom> poms, File outputFile) {
        StringBuffer dependenciesCsv = new StringBuffer();
        Iterable $this$forEach$iv = poms;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Pom pom = (Pom)element$iv;
            boolean bl = false;
            List<PomLicense> list = pom.getLicenses();
            PomLicense license = list != null ? (PomLicense)CollectionsKt.firstOrNull(list) : null;
            String formattedPomUrl = this.formatUrl(pom.getUrl());
            String string2 = pom.getName();
            if (string2 == null) {
                string2 = string = pom.getArtifactId();
            }
            if (string2 == null) {
                string = "";
            }
            StringBuffer stringBuffer = dependenciesCsv.append(this.formatCsvName(string)).append(',');
            String string3 = formattedPomUrl;
            if (string3 == null) {
                string3 = "";
            }
            StringBuffer stringBuffer2 = stringBuffer.append(string3).append(',');
            String string4 = pom.getGroupId();
            if (string4 == null) {
                string4 = "";
            }
            StringBuffer stringBuffer3 = stringBuffer2.append(string4).append(',');
            String string5 = pom.getArtifactId();
            if (string5 == null) {
                string5 = "";
            }
            StringBuffer stringBuffer4 = stringBuffer3.append(string5).append(',');
            String string6 = pom.getVersion();
            if (string6 == null) {
                string6 = "";
            }
            StringBuffer stringBuffer5 = stringBuffer4.append(string6).append(',');
            Object object = license;
            if (object == null || (object = ((PomLicense)object).getName()) == null) {
                object = "";
            }
            StringBuffer stringBuffer6 = stringBuffer5.append(this.formatCsvName((String)object)).append(',');
            Object object2 = license;
            if (object2 == null || (object2 = ((PomLicense)object2).getUrl()) == null) {
                object2 = "";
            }
            stringBuffer6.append((String)object2).append('\n');
        }
        if (outputFile.exists()) {
            outputFile.delete();
        }
        String string = dependenciesCsv.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependenciesCsv.toString()");
        FilesKt.writeText$default((File)outputFile, (String)string, null, (int)2, null);
    }

    private final File getOutputDir(String pathname) {
        File outputDir = new File(pathname);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        boolean bl = outputDir.exists();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Failed to create output directory: [" + this.extension.getOutputDir() + ']';
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return outputDir;
    }

    @Nested
    @NotNull
    public final LicenseManagerExtension getExtension() {
        return this.extension;
    }

    @Inject
    public ReportTask(@NotNull LicenseManagerExtension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.extension = extension;
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
        this.setGroup("License");
        this.setDescription("Creates reports/files for licences");
    }

    public static final /* synthetic */ String access$formatUrl(ReportTask $this, String url) {
        return $this.formatUrl(url);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/dbtools/licensemanager/ReportTask$Companion;", "", "()V", "POM_CONFIGURATION", "", "license-manager"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

