/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.system;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QLog {
    private static final Logger _log = LoggerFactory.getLogger(QLog.class);
    protected static boolean _queryLogLevelInfo;
    protected static boolean _loggingInHolidayMood;
    protected static boolean _locked;

    public static void log(String sql) {
        if (_queryLogLevelInfo) {
            _log.info(sql);
        } else {
            _log.debug(sql);
        }
    }

    public static boolean isLogEnabled() {
        if (_loggingInHolidayMood) {
            return false;
        }
        if (_queryLogLevelInfo) {
            return _log.isInfoEnabled();
        }
        return _log.isDebugEnabled();
    }

    protected static boolean isQueryLogLevelInfo() {
        return _queryLogLevelInfo;
    }

    public static void setQueryLogLevelInfo(boolean queryLogLevelInfo) {
        QLog.assertUnlocked();
        if (_log.isInfoEnabled()) {
            _log.info("...Setting queryLogLevelInfo: " + queryLogLevelInfo);
        }
        _queryLogLevelInfo = queryLogLevelInfo;
        QLog.lock();
    }

    protected static boolean isLoggingInHolidayMood() {
        return _loggingInHolidayMood;
    }

    public static void setLoggingInHolidayMood(boolean loggingInHolidayMood) {
        QLog.assertUnlocked();
        if (_log.isInfoEnabled()) {
            _log.info("...Setting loggingInHolidayMood: " + loggingInHolidayMood);
        }
        _loggingInHolidayMood = loggingInHolidayMood;
        QLog.lock();
    }

    public static boolean isLocked() {
        return _locked;
    }

    public static void lock() {
        if (_locked) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("...Locking the log object for query!");
        }
        _locked = true;
    }

    public static void unlock() {
        if (!_locked) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("...Unlocking the log object for query!");
        }
        _locked = false;
    }

    protected static void assertUnlocked() {
        if (!QLog.isLocked()) {
            return;
        }
        throw new IllegalStateException("The query log is locked.");
    }

    static {
        _locked = true;
    }
}

