/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.system;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.dbflute.system.provider.DfCurrentDateProvider;
import org.dbflute.system.provider.DfFinalLocaleProvider;
import org.dbflute.system.provider.DfFinalTimeZoneProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBFluteSystem {
    private static final Logger _log = LoggerFactory.getLogger(DBFluteSystem.class);
    protected static DfCurrentDateProvider _currentDateProvider;
    protected static DfFinalLocaleProvider _finalLocaleProvider;
    protected static DfFinalTimeZoneProvider _finalTimeZoneProvider;
    protected static boolean _locked;

    public static LocalDate currentLocalDate() {
        return DBFluteSystem.currentZonedDateTime().toLocalDate();
    }

    public static LocalDateTime currentLocalDateTime() {
        return DBFluteSystem.currentZonedDateTime().toLocalDateTime();
    }

    public static ZonedDateTime currentZonedDateTime() {
        TimeZone timeZone = DBFluteSystem.getFinalTimeZone();
        return ZonedDateTime.ofInstant(DBFluteSystem.currentDate().toInstant(), timeZone.toZoneId());
    }

    public static Date currentDate() {
        return new Date(DBFluteSystem.currentTimeMillis());
    }

    public static Timestamp currentTimestamp() {
        return new Timestamp(DBFluteSystem.currentTimeMillis());
    }

    public static long currentTimeMillis() {
        long millis = _currentDateProvider != null ? _currentDateProvider.currentTimeMillis() : System.currentTimeMillis();
        return millis;
    }

    public static Locale getFinalLocale() {
        return _finalLocaleProvider != null ? _finalLocaleProvider.provide() : Locale.getDefault();
    }

    public static TimeZone getFinalTimeZone() {
        return _finalTimeZoneProvider != null ? _finalTimeZoneProvider.provide() : TimeZone.getDefault();
    }

    public static String ln() {
        return "\n";
    }

    public static boolean hasCurrentDateProvider() {
        return _currentDateProvider != null;
    }

    public static void setCurrentDateProvider(DfCurrentDateProvider currentDateProvider) {
        DBFluteSystem.assertUnlocked();
        if (_log.isInfoEnabled()) {
            _log.info("...Setting currentDateProvider: " + currentDateProvider);
        }
        _currentDateProvider = currentDateProvider;
        DBFluteSystem.lock();
    }

    public static boolean hasFinalLocaleProvider() {
        return _finalTimeZoneProvider != null;
    }

    public static void setFinalLocaleProvider(DfFinalLocaleProvider finalLocaleProvider) {
        DBFluteSystem.assertUnlocked();
        if (_log.isInfoEnabled()) {
            _log.info("...Setting finalLocaleProvider: " + finalLocaleProvider);
        }
        _finalLocaleProvider = finalLocaleProvider;
        DBFluteSystem.lock();
    }

    public static boolean hasFinalTimeZoneProvider() {
        return _finalTimeZoneProvider != null;
    }

    public static void setFinalTimeZoneProvider(DfFinalTimeZoneProvider finalTimeZoneProvider) {
        DBFluteSystem.assertUnlocked();
        if (_log.isInfoEnabled()) {
            _log.info("...Setting finalTimeZoneProvider: " + finalTimeZoneProvider);
        }
        _finalTimeZoneProvider = finalTimeZoneProvider;
        DBFluteSystem.lock();
    }

    public static void lock() {
        if (_locked) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("...Locking the DBFlute system");
        }
        _locked = true;
    }

    public static void unlock() {
        if (!_locked) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("...Unlocking the DBFlute system");
        }
        _locked = false;
    }

    public static boolean isLocked() {
        return _locked;
    }

    protected static void assertUnlocked() {
        if (!DBFluteSystem.isLocked()) {
            return;
        }
        throw new IllegalStateException("The DBFlute system is locked.");
    }

    static {
        _locked = true;
    }
}

