/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.valuetype.plugin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbflute.s2dao.valuetype.TnAbstractValueType;
import org.dbflute.util.DfResourceUtil;

public class BytesType
extends TnAbstractValueType {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final Trait BYTES_TRAIT = new BytesTrait();
    public static final Trait STREAM_TRAIT = new StreamTrait();
    public static final Trait BLOB_TRAIT = new BlobTrait();
    protected Trait trait;

    public BytesType(Trait trait) {
        super(trait.getSqlType());
        this.trait = trait;
    }

    @Override
    public void bindValue(Connection conn, PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else if (value instanceof byte[]) {
            this.trait.set(ps, index, (byte[])value);
        } else {
            ps.setObject(index, value);
        }
    }

    @Override
    public void bindValue(Connection conn, CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else if (value instanceof byte[]) {
            this.trait.set(cs, parameterName, (byte[])value);
        } else {
            cs.setObject(parameterName, value);
        }
    }

    @Override
    public Object getValue(ResultSet rs, int index) throws SQLException {
        return this.trait.get(rs, index);
    }

    @Override
    public Object getValue(ResultSet rs, String columnName) throws SQLException {
        return this.trait.get(rs, columnName);
    }

    @Override
    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.trait.get(cs, index);
    }

    @Override
    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.trait.get(cs, parameterName);
    }

    public static byte[] toBytes(InputStream is) throws SQLException {
        try {
            byte[] bytes = new byte[is.available()];
            is.read(bytes);
            return bytes;
        }
        catch (IOException e) {
            String msg = "The IOException occurred: " + is;
            throw new IllegalStateException(msg, e);
        }
    }

    public static byte[] toBytes(Blob blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        long length = blob.length();
        if (length == 0L) {
            return EMPTY_BYTES;
        }
        if (length > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return blob.getBytes(1L, (int)length);
    }

    public static class BlobTrait
    implements Trait {
        @Override
        public int getSqlType() {
            return 2004;
        }

        @Override
        public void set(PreparedStatement ps, int parameterIndex, byte[] bytes) throws SQLException {
            ps.setBinaryStream(parameterIndex, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        }

        @Override
        public void set(CallableStatement cs, String parameterName, byte[] bytes) throws SQLException {
            cs.setBinaryStream(parameterName, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        }

        @Override
        public byte[] get(ResultSet rs, int columnIndex) throws SQLException {
            return BytesType.toBytes(rs.getBlob(columnIndex));
        }

        @Override
        public byte[] get(ResultSet rs, String columnName) throws SQLException {
            return BytesType.toBytes(rs.getBlob(columnName));
        }

        @Override
        public byte[] get(CallableStatement cs, int columnIndex) throws SQLException {
            return BytesType.toBytes(cs.getBlob(columnIndex));
        }

        @Override
        public byte[] get(CallableStatement cs, String columnName) throws SQLException {
            return BytesType.toBytes(cs.getBlob(columnName));
        }
    }

    public static class StreamTrait
    implements Trait {
        @Override
        public int getSqlType() {
            return -2;
        }

        @Override
        public void set(PreparedStatement ps, int parameterIndex, byte[] bytes) throws SQLException {
            ps.setBinaryStream(parameterIndex, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        }

        @Override
        public void set(CallableStatement cs, String parameterName, byte[] bytes) throws SQLException {
            cs.setBinaryStream(parameterName, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] get(ResultSet rs, int columnIndex) throws SQLException {
            InputStream is = rs.getBinaryStream(columnIndex);
            try {
                byte[] byArray = BytesType.toBytes(is);
                return byArray;
            }
            finally {
                DfResourceUtil.close(is);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] get(ResultSet rs, String columnName) throws SQLException {
            InputStream is = rs.getBinaryStream(columnName);
            try {
                byte[] byArray = BytesType.toBytes(is);
                return byArray;
            }
            finally {
                DfResourceUtil.close(is);
            }
        }

        @Override
        public byte[] get(CallableStatement cs, int columnIndex) throws SQLException {
            return cs.getBytes(columnIndex);
        }

        @Override
        public byte[] get(CallableStatement cs, String columnName) throws SQLException {
            return cs.getBytes(columnName);
        }
    }

    public static class BytesTrait
    implements Trait {
        @Override
        public int getSqlType() {
            return -2;
        }

        @Override
        public void set(PreparedStatement ps, int parameterIndex, byte[] bytes) throws SQLException {
            ps.setBytes(parameterIndex, bytes);
        }

        @Override
        public void set(CallableStatement cs, String parameterName, byte[] bytes) throws SQLException {
            cs.setBytes(parameterName, bytes);
        }

        @Override
        public byte[] get(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getBytes(columnIndex);
        }

        @Override
        public byte[] get(ResultSet rs, String columnName) throws SQLException {
            return rs.getBytes(columnName);
        }

        @Override
        public byte[] get(CallableStatement cs, int columnIndex) throws SQLException {
            return cs.getBytes(columnIndex);
        }

        @Override
        public byte[] get(CallableStatement cs, String columnName) throws SQLException {
            return cs.getBytes(columnName);
        }
    }

    public static interface Trait {
        public int getSqlType();

        public void set(PreparedStatement var1, int var2, byte[] var3) throws SQLException;

        public void set(CallableStatement var1, String var2, byte[] var3) throws SQLException;

        public byte[] get(ResultSet var1, int var2) throws SQLException;

        public byte[] get(ResultSet var1, String var2) throws SQLException;

        public byte[] get(CallableStatement var1, int var2) throws SQLException;

        public byte[] get(CallableStatement var1, String var2) throws SQLException;
    }
}

