/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.jdbc;

import org.dbflute.jdbc.ValueType;
import org.dbflute.s2dao.extension.TnRelationRowCreatorExtension;
import org.dbflute.s2dao.extension.TnRelationRowOptionalHandler;
import org.dbflute.s2dao.extension.TnRowCreatorExtension;
import org.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.dbflute.s2dao.jdbc.TnResultSetHandlerFactory;
import org.dbflute.s2dao.metadata.TnBeanMetaData;
import org.dbflute.s2dao.rshandler.TnBeanCursorResultSetHandler;
import org.dbflute.s2dao.rshandler.TnBeanListResultSetHandler;
import org.dbflute.s2dao.rshandler.TnScalarDynamicResultSetHandler;
import org.dbflute.s2dao.rshandler.TnScalarListResultSetHandler;
import org.dbflute.s2dao.rshandler.TnScalarResultSetHandler;
import org.dbflute.s2dao.valuetype.TnValueTypes;

public class TnResultSetHandlerFactoryImpl
implements TnResultSetHandlerFactory {
    @Override
    public TnResultSetHandler createBeanListResultSetHandler(TnBeanMetaData bmd, TnRelationRowOptionalHandler optionalHandler) {
        TnRowCreatorExtension rowCreator = this.createRowCreator(bmd);
        TnRelationRowCreatorExtension relationRowCreator = this.createRelationRowCreator(bmd, optionalHandler);
        return new TnBeanListResultSetHandler(bmd, rowCreator, relationRowCreator);
    }

    @Override
    public TnResultSetHandler createBeanCursorResultSetHandler(TnBeanMetaData bmd, TnRelationRowOptionalHandler optionalHandler) {
        TnRowCreatorExtension rowCreator = this.createRowCreator(bmd);
        TnRelationRowCreatorExtension relationRowCreator = this.createRelationRowCreator(bmd, optionalHandler);
        return new TnBeanCursorResultSetHandler(bmd, rowCreator, relationRowCreator);
    }

    @Override
    public TnResultSetHandler createScalarResultSetHandler(Class<?> objectType) {
        ValueType valueType = TnValueTypes.getValueType(objectType);
        return new TnScalarResultSetHandler(valueType);
    }

    @Override
    public TnResultSetHandler createDynamicScalarResultSetHandler(Class<?> objectType) {
        ValueType valueType = TnValueTypes.getValueType(objectType);
        return new TnScalarDynamicResultSetHandler(valueType);
    }

    @Override
    public TnResultSetHandler createScalarListResultSetHandler(Class<?> objectType) {
        ValueType valueType = TnValueTypes.getValueType(objectType);
        return this.newScalarListResultSetHandler(valueType);
    }

    @Override
    public TnResultSetHandler createScalarListResultSetHandler(ValueType valueType) {
        return this.newScalarListResultSetHandler(valueType);
    }

    protected TnScalarListResultSetHandler newScalarListResultSetHandler(ValueType valueType) {
        return new TnScalarListResultSetHandler(valueType);
    }

    protected TnRowCreatorExtension createRowCreator(TnBeanMetaData bmd) {
        Class<?> clazz = bmd != null ? bmd.getBeanClass() : null;
        return TnRowCreatorExtension.createRowCreator(clazz);
    }

    protected TnRelationRowCreatorExtension createRelationRowCreator(TnBeanMetaData bmd, TnRelationRowOptionalHandler optionalHandler) {
        return TnRelationRowCreatorExtension.createRelationRowCreator(optionalHandler);
    }
}

