/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.helper.token.line;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dbflute.helper.token.line.LineMakingOption;
import org.dbflute.helper.token.line.LineTokenOptionCall;
import org.dbflute.helper.token.line.LineTokenizingOption;
import org.dbflute.util.Srl;

public class LineToken {
    public List<String> tokenize(String lineString, LineTokenOptionCall<LineTokenizingOption> opLambda) {
        LineTokenizingOption option = this.createLineTokenizingOption(opLambda);
        String delimiter = option.getDelimiter();
        ArrayList<String> list = new ArrayList<String>();
        int elementIndex = 0;
        int delimiterIndex = lineString.indexOf(delimiter);
        while (delimiterIndex >= 0) {
            String value = lineString.substring(elementIndex, delimiterIndex);
            list.add(this.filterHandlingEmptyAsNull(value, option));
            elementIndex = delimiterIndex + delimiter.length();
            delimiterIndex = lineString.indexOf(delimiter, elementIndex);
        }
        String lastElement = lineString.substring(elementIndex);
        list.add(this.filterHandlingEmptyAsNull(lastElement, option));
        return list;
    }

    protected LineTokenizingOption createLineTokenizingOption(LineTokenOptionCall<LineTokenizingOption> opLambda) {
        this.assertObjectNotNull("opLambda", opLambda);
        LineTokenizingOption op = this.newLineTokenizingOption();
        opLambda.callback(op);
        return op;
    }

    protected LineTokenizingOption newLineTokenizingOption() {
        return new LineTokenizingOption();
    }

    protected String filterHandlingEmptyAsNull(String target, LineTokenizingOption lineTokenizingOption) {
        if (target == null) {
            return null;
        }
        if (lineTokenizingOption.isHandleEmtpyAsNull() && "".equals(target)) {
            return null;
        }
        return target;
    }

    public String make(Collection<String> valueList, LineTokenOptionCall<LineMakingOption> opLambda) {
        LineMakingOption option = this.createLineMakingOption(opLambda);
        this.assertObjectNotNull("valueList", valueList);
        this.assertObjectNotNull("lineMakingOption", option);
        String delimiter = option.getDelimiter();
        this.assertObjectNotNull("lineMakingOption.getDelimiter()", delimiter);
        return this.createLineString(valueList, delimiter, option.isQuoteAll(), option.isQuoteMinimally(), option.isTrimSpace());
    }

    protected LineMakingOption createLineMakingOption(LineTokenOptionCall<LineMakingOption> opLambda) {
        this.assertObjectNotNull("opLambda", opLambda);
        LineMakingOption op = this.newLineMakingOption();
        opLambda.callback(op);
        return op;
    }

    protected LineMakingOption newLineMakingOption() {
        return new LineMakingOption();
    }

    protected String createLineString(Collection<String> valueList, String delimiter, boolean quoteAll, boolean quoteMinimamlly, boolean trimSpace) {
        StringBuilder sb = new StringBuilder();
        for (String value : valueList) {
            String string = value = value != null ? value : "";
            if (trimSpace) {
                value = value.trim();
            }
            if (quoteAll) {
                value = Srl.replace(value, "\"", "\"\"");
                sb.append(delimiter).append("\"").append(value).append("\"");
                continue;
            }
            if (quoteMinimamlly && this.needsQuote(value, delimiter)) {
                value = Srl.replace(value, "\"", "\"\"");
                sb.append(delimiter).append("\"").append(value).append("\"");
                continue;
            }
            sb.append(delimiter).append(value);
        }
        sb.delete(0, delimiter.length());
        return sb.toString();
    }

    protected boolean needsQuote(String value, String delimiter) {
        return value.contains("\"") || value.contains("\r") || value.contains("\n") || value.contains(delimiter);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }
}

